/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.delta.monitor;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.delta.IEnumDelta;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.SafeIntProcedure;

public class OneValueDeltaMonitor
implements IIntDeltaMonitor {
    protected final IEnumDelta delta;
    protected boolean used;
    protected ICause propagator;

    public OneValueDeltaMonitor(IEnumDelta delta, ICause propagator) {
        this.delta = delta;
        this.used = false;
        this.propagator = propagator;
    }

    @Override
    public void freeze() {
        this.used = this.delta.size() == 1;
    }

    @Override
    public void unfreeze() {
        this.used = false;
        this.delta.lazyClear();
    }

    @Override
    public void forEachRemVal(SafeIntProcedure proc) {
        if (this.used && this.propagator != this.delta.getCause(0)) {
            proc.execute(this.delta.get(0));
        }
    }

    @Override
    public void forEachRemVal(IntProcedure proc) throws ContradictionException {
        if (this.used && this.propagator != this.delta.getCause(0)) {
            proc.execute(this.delta.get(0));
        }
    }
}

