/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.events;

import org.chocosolver.solver.variables.events.IEventType;

public enum IntEventType implements IEventType
{
    VOID(0, 0),
    REMOVE(1, 1),
    INCLOW(2, 3),
    DECUPP(4, 5),
    BOUND(6, 7),
    INSTANTIATE(8, 15);

    private final int mask;
    private final int strengthened_mask;

    private IntEventType(int mask, int fullmask) {
        this.mask = mask;
        this.strengthened_mask = fullmask;
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    @Override
    public int getStrengthenedMask() {
        return this.strengthened_mask;
    }

    public static int all() {
        return INSTANTIATE.getStrengthenedMask();
    }

    public static int boundAndInst() {
        return INSTANTIATE.getStrengthenedMask() - REMOVE.getStrengthenedMask();
    }

    public static int instantiation() {
        return INSTANTIATE.getMask();
    }

    public static boolean isInstantiate(int mask) {
        return (mask & IntEventType.INSTANTIATE.mask) != 0;
    }

    public static boolean isRemove(int mask) {
        return (mask & IntEventType.REMOVE.mask) != 0;
    }

    public static boolean isBound(int mask) {
        return (mask & IntEventType.BOUND.mask) != 0;
    }

    public static boolean isInclow(int mask) {
        return (mask & IntEventType.INCLOW.mask) != 0;
    }

    public static boolean isDecupp(int mask) {
        return (mask & IntEventType.DECUPP.mask) != 0;
    }
}

