/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import java.util.Arrays;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IVariableMonitor;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.view.IView;

public abstract class AbstractVariable
implements Variable {
    private static final long serialVersionUID = 1L;
    public static final String MSG_REMOVE = "remove last value";
    public static final String MSG_EMPTY = "empty domain";
    public static final String MSG_INST = "already instantiated";
    public static final String MSG_UNKNOWN = "unknown value";
    public static final String MSG_UPP = "new lower bound is greater than upper bound";
    public static final String MSG_LOW = "new upper bound is lesser than lower bound";
    public static final String MSG_BOUND = "new bounds are incorrect";
    private final int ID;
    protected final Solver solver;
    protected final String name;
    private Propagator[] propagators;
    private int[] pindices;
    private int pIdx;
    private IView[] views;
    private int vIdx;
    protected IVariableMonitor[] monitors;
    protected int mIdx;
    protected int modificationEvents;
    protected final boolean _plugexpl;

    protected AbstractVariable(String name, Solver solver) {
        this.name = name;
        this.solver = solver;
        this.views = new IView[2];
        this.monitors = new IVariableMonitor[2];
        this.propagators = new Propagator[8];
        this.pindices = new int[8];
        this.ID = solver.nextId();
        this._plugexpl = solver.getSettings().plugExplanationIn();
        solver.associates(this);
    }

    @Override
    public int getId() {
        return this.ID;
    }

    @Override
    public int link(Propagator propagator, int idxInProp) {
        if (this.pIdx == this.propagators.length) {
            Propagator[] tmp = this.propagators;
            this.propagators = new Propagator[tmp.length * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.propagators, 0, this.pIdx);
            int[] itmp = this.pindices;
            this.pindices = new int[itmp.length * 3 / 2 + 1];
            System.arraycopy(itmp, 0, this.pindices, 0, this.pIdx);
        }
        this.propagators[this.pIdx] = propagator;
        this.pindices[this.pIdx++] = idxInProp;
        return this.pIdx - 1;
    }

    @Override
    public void recordMask(int mask) {
        this.modificationEvents |= mask;
    }

    @Override
    public void unlink(Propagator propagator) {
        int i;
        for (i = 0; i < this.pIdx && this.propagators[i] != propagator; ++i) {
        }
        if (i < this.pIdx) {
            this.propagators[i] = this.propagators[this.pIdx - 1];
            this.pindices[i] = this.pindices[--this.pIdx];
            this.propagators[this.pIdx] = null;
            this.pindices[this.pIdx] = 0;
        }
    }

    @Override
    public Propagator[] getPropagators() {
        if (this.propagators.length > this.pIdx) {
            this.propagators = Arrays.copyOf(this.propagators, this.pIdx);
        }
        return this.propagators;
    }

    @Override
    public Propagator getPropagator(int idx) {
        return this.propagators[idx];
    }

    @Override
    public int getNbProps() {
        return this.pIdx;
    }

    @Override
    public int[] getPIndices() {
        if (this.pindices.length > this.pIdx) {
            this.pindices = Arrays.copyOf(this.pindices, this.pIdx);
        }
        return this.pindices;
    }

    @Override
    public int getIndexInPropagator(int pidx) {
        return this.pindices[pidx];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void notifyPropagators(IEventType event, ICause cause) throws ContradictionException {
        assert (cause != null);
        this.notifyMonitors(event);
        if ((this.modificationEvents & event.getMask()) != 0) {
            this.solver.getEngine().onVariableUpdate(this, event, cause);
        }
        this.notifyViews(event, cause);
    }

    @Override
    public void notifyViews(IEventType event, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (cause == Cause.Null) {
            for (int i = this.vIdx - 1; i >= 0; --i) {
                this.views[i].transformEvent(event, cause);
            }
        } else {
            for (int i = this.vIdx - 1; i >= 0; --i) {
                if (this.views[i] == cause) continue;
                this.views[i].transformEvent(event, cause);
            }
        }
    }

    @Override
    public void addMonitor(IVariableMonitor monitor) {
        for (int i = 0; i < this.mIdx; ++i) {
            if (this.monitors[i] != monitor) continue;
            return;
        }
        if (this.mIdx == this.monitors.length) {
            IVariableMonitor[] tmp = this.monitors;
            this.monitors = new IVariableMonitor[tmp.length * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.monitors, 0, this.mIdx);
        }
        this.monitors[this.mIdx++] = monitor;
    }

    @Override
    public void removeMonitor(IVariableMonitor monitor) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public void subscribeView(IView view) {
        if (this.vIdx == this.views.length) {
            IView[] tmp = this.views;
            this.views = new IView[tmp.length * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.views, 0, this.vIdx);
        }
        this.views[this.vIdx++] = view;
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }

    @Override
    public IView[] getViews() {
        return Arrays.copyOfRange(this.views, 0, this.vIdx);
    }

    @Override
    public int compareTo(Variable o) {
        return this.getId() - o.getId();
    }

    public String toString() {
        return this.getName();
    }

    public boolean isBool() {
        return (this.getTypeAndKind() & 0xF8) == 24;
    }
}

