/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateBitSet;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.explanations.antidom.AntiDomBitset;
import org.chocosolver.solver.explanations.antidom.AntiDomain;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.EnumDelta;
import org.chocosolver.solver.variables.delta.IEnumDelta;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.delta.monitor.EnumDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.tools.StringUtils;

public final class BitsetArrayIntVarImpl
extends AbstractVariable
implements IntVar {
    private static final long serialVersionUID = 1L;
    protected boolean reactOnRemoval = false;
    private final int[] values;
    private final IStateBitSet indexes;
    private final IStateInt LB;
    private final IStateInt UB;
    private final IStateInt SIZE;
    private final int LENGTH;
    private IEnumDelta delta = NoDelta.singleton;
    private DisposableValueIterator _viterator;
    private DisposableRangeIterator _riterator;

    public BitsetArrayIntVarImpl(String name, int[] sortedValues, Solver solver) {
        super(name, solver);
        IEnvironment env = solver.getEnvironment();
        this.LENGTH = sortedValues.length;
        this.values = (int[])sortedValues.clone();
        this.indexes = env.makeBitSet(this.LENGTH);
        this.indexes.set(0, this.LENGTH);
        this.LB = env.makeInt(0);
        this.UB = env.makeInt(this.LENGTH - 1);
        this.SIZE = env.makeInt(this.LENGTH);
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (value < this.values[this.LB.get()] || value > this.values[this.UB.get()]) {
            return false;
        }
        int index = -1;
        int i = this.indexes.nextSetBit(this.LB.get());
        while (i >= 0 && this.values[i] <= value) {
            if (this.values[i] == value) {
                index = i;
                break;
            }
            i = this.indexes.nextSetBit(i + 1);
        }
        if (index != -1) {
            if (this.SIZE.get() == 1) {
                if (this._plugexpl) {
                    this.solver.getExplainer().removeValue(this, value, cause);
                }
                this.contradiction(cause, IntEventType.REMOVE, "remove last value");
            }
            IntEventType e = IntEventType.REMOVE;
            this.indexes.clear(index);
            this.SIZE.add(-1);
            if (this.reactOnRemoval) {
                this.delta.add(value, cause);
            }
            if (value == this.getLB()) {
                this.LB.set(this.indexes.nextSetBit(this.LB.get()));
                e = IntEventType.INCLOW;
            } else if (value == this.getUB()) {
                this.UB.set(this.indexes.prevSetBit(this.UB.get()));
                e = IntEventType.DECUPP;
            }
            assert (!this.indexes.isEmpty());
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            this.notifyPropagators(e, cause);
            if (this._plugexpl) {
                this.solver.getExplainer().removeValue(this, value, cause);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (from <= this.getLB()) {
            return this.updateLowerBound(to + 1, cause);
        }
        if (this.getUB() <= to) {
            return this.updateUpperBound(from - 1, cause);
        }
        boolean anyChange = false;
        int v = this.nextValue(from - 1);
        while (v <= to) {
            anyChange |= this.removeValue(v, cause);
            v = this.nextValue(v);
        }
        return anyChange;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (this.isInstantiated()) {
            int cvalue = this.getValue();
            if (value != cvalue) {
                if (this._plugexpl) {
                    this.solver.getExplainer().instantiateTo(this, value, cause, cvalue, cvalue);
                }
                this.contradiction(cause, IntEventType.INSTANTIATE, "already instantiated");
            }
            return false;
        }
        int index = -1;
        int i = this.indexes.nextSetBit(this.LB.get());
        while (i >= 0 && this.values[i] <= value) {
            if (this.values[i] == value) {
                index = i;
                break;
            }
            i = this.indexes.nextSetBit(i + 1);
        }
        if (index != -1) {
            if (this.reactOnRemoval) {
                i = this.indexes.nextSetBit(this.LB.get());
                while (i >= 0) {
                    if (i != index) {
                        this.delta.add(this.values[i], cause);
                    }
                    i = this.indexes.nextSetBit(i + 1);
                }
            }
            int oldLB = 0;
            int oldUB = 0;
            if (this._plugexpl) {
                oldLB = this.getLB();
                oldUB = this.getUB();
            }
            this.indexes.clear();
            this.indexes.set(index);
            this.LB.set(index);
            this.UB.set(index);
            this.SIZE.set(1);
            if (this.indexes.isEmpty()) {
                this.contradiction(cause, IntEventType.INSTANTIATE, "empty domain");
            }
            if (this._plugexpl) {
                this.solver.getExplainer().instantiateTo(this, value, cause, oldLB, oldUB);
            }
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        if (this._plugexpl) {
            this.solver.getExplainer().instantiateTo(this, value, cause, this.getLB(), this.getUB());
        }
        this.contradiction(cause, IntEventType.INSTANTIATE, "unknown value");
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getLB();
        if (old < value) {
            int oub = this.getUB();
            if (oub < value) {
                if (this._plugexpl) {
                    this.solver.getExplainer().updateLowerBound(this, old, oub + 1, cause);
                }
                this.contradiction(cause, IntEventType.INCLOW, "new upper bound is lesser than lower bound");
            } else {
                IntEventType e = IntEventType.INCLOW;
                int index = this.indexes.nextSetBit(this.LB.get());
                while (index >= 0 && this.values[index] < value) {
                    index = this.indexes.nextSetBit(index + 1);
                }
                assert (index >= 0 && this.values[index] >= value);
                if (this.reactOnRemoval) {
                    int i = this.LB.get();
                    while (i >= 0 && i < index) {
                        this.delta.add(this.values[i], cause);
                        i = this.indexes.nextSetBit(i + 1);
                    }
                }
                this.indexes.clear(this.LB.get(), index);
                this.LB.set(index);
                assert (this.SIZE.get() > this.indexes.cardinality());
                this.SIZE.set(this.indexes.cardinality());
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                if (this._plugexpl) {
                    this.solver.getExplainer().updateLowerBound(this, old, value, cause);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getUB();
        if (old > value) {
            int olb = this.getLB();
            if (olb > value) {
                if (this._plugexpl) {
                    this.solver.getExplainer().updateUpperBound(this, old, olb - 1, cause);
                }
                this.contradiction(cause, IntEventType.DECUPP, "new lower bound is greater than upper bound");
            } else {
                IntEventType e = IntEventType.DECUPP;
                int index = this.indexes.prevSetBit(this.UB.get());
                while (index >= 0 && this.values[index] > value) {
                    index = this.indexes.prevSetBit(index - 1);
                }
                assert (index >= 0 && this.values[index] <= value);
                if (this.reactOnRemoval) {
                    int i = this.UB.get();
                    while (i > index) {
                        this.delta.add(this.values[i], cause);
                        i = this.indexes.prevSetBit(i - 1);
                    }
                }
                this.indexes.clear(index + 1, this.UB.get() + 1);
                this.UB.set(index);
                assert (this.SIZE.get() > this.indexes.cardinality());
                this.SIZE.set(this.indexes.cardinality());
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                if (this._plugexpl) {
                    this.solver.getExplainer().updateUpperBound(this, old, value, cause);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void wipeOut(ICause cause) throws ContradictionException {
        assert (cause != null);
        this.removeInterval(this.getLB(), this.getUB(), cause);
    }

    @Override
    public boolean isInstantiated() {
        return this.SIZE.get() == 1;
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.isInstantiated() && this.contains(value);
    }

    @Override
    public boolean contains(int aValue) {
        if (aValue >= this.getLB() && aValue <= this.getUB()) {
            int i = this.indexes.nextSetBit(this.LB.get());
            while (i >= 0 && this.values[i] <= aValue) {
                if (this.values[i] == aValue) {
                    return true;
                }
                i = this.indexes.nextSetBit(i + 1);
            }
        }
        return false;
    }

    @Override
    public int getValue() {
        assert (this.isInstantiated()) : this.name + " not instantiated";
        return this.getLB();
    }

    @Override
    public int getLB() {
        assert (this.LB.get() >= 0 && this.LB.get() < this.LENGTH);
        return this.values[this.LB.get()];
    }

    @Override
    public int getUB() {
        assert (this.UB.get() >= 0 && this.UB.get() < this.LENGTH);
        return this.values[this.UB.get()];
    }

    @Override
    public int getDomainSize() {
        return this.SIZE.get();
    }

    @Override
    public int nextValue(int aValue) {
        int lb = this.getLB();
        if (aValue < lb) {
            return lb;
        }
        if (aValue >= this.getUB()) {
            return Integer.MAX_VALUE;
        }
        int i = this.indexes.nextSetBit(this.LB.get());
        while (i >= 0 && this.values[i] <= aValue) {
            i = this.indexes.nextSetBit(i + 1);
        }
        return i >= 0 ? this.values[i] : Integer.MAX_VALUE;
    }

    @Override
    public int previousValue(int aValue) {
        int ub = this.getUB();
        if (aValue > ub) {
            return ub;
        }
        if (aValue <= this.getLB()) {
            return Integer.MIN_VALUE;
        }
        int i = this.indexes.prevSetBit(this.UB.get());
        while (i >= 0 && this.values[i] >= aValue) {
            i = this.indexes.prevSetBit(i - 1);
        }
        return i >= 0 ? this.values[i] : Integer.MIN_VALUE;
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return true;
    }

    @Override
    public IEnumDelta getDelta() {
        return this.delta;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(20);
        s.append(this.name).append(" = ");
        if (this.SIZE.get() == 1) {
            s.append(this.getLB());
        } else {
            int nb;
            s.append('{').append(this.getLB());
            int i = this.nextValue(this.getLB());
            for (nb = 5; i < Integer.MAX_VALUE && nb > 0; --nb) {
                s.append(',').append(i);
                i = this.nextValue(i);
            }
            if (nb == 0 && this.SIZE.get() > 6) {
                s.append("...,").append(this.getUB());
            }
            s.append('}');
        }
        return s.toString();
    }

    @Override
    public void createDelta() {
        if (!this.reactOnRemoval) {
            this.delta = new EnumDelta(this.solver.getSearchLoop());
            this.reactOnRemoval = true;
        }
    }

    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new EnumDeltaMonitor(this.delta, propagator);
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
        for (int i = this.mIdx - 1; i >= 0; --i) {
            this.monitors[i].onUpdate(this, event);
        }
    }

    @Override
    public AntiDomain antiDomain() {
        return new AntiDomBitset(this);
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, Explanation to) {
        AntiDomain invdom = xengine.getRemovedValues(this);
        DisposableValueIterator it = invdom.getValueIterator();
        while (it.hasNext()) {
            int val = it.next();
            if (!(what == VariableState.LB && val < this.getLB() || what == VariableState.UB && val > this.getUB()) && what != VariableState.DOM) continue;
            to.add(xengine.explain(this, val));
        }
        it.dispose();
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, int val, Explanation to) {
        to.add(xengine.explain(this, val));
    }

    @Override
    public void contradiction(ICause cause, IEventType event, String message) throws ContradictionException {
        assert (cause != null);
        this.solver.getEngine().fails(cause, this, message);
    }

    @Override
    public int getTypeAndKind() {
        return 9;
    }

    public IntVar duplicate() {
        return new BitsetArrayIntVarImpl(StringUtils.randomName(this.name), (int[])this.values.clone(), this.getSolver());
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            BitsetArrayIntVarImpl clone = new BitsetArrayIntVarImpl(this.name, this.values, solver);
            identitymap.put(this, clone);
        }
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || !this._viterator.isReusable()) {
            this._viterator = new DisposableValueIterator(){
                int index;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.index = BitsetArrayIntVarImpl.this.indexes.nextSetBit(BitsetArrayIntVarImpl.this.LB.get());
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.index = BitsetArrayIntVarImpl.this.indexes.prevSetBit(BitsetArrayIntVarImpl.this.UB.get());
                }

                @Override
                public boolean hasNext() {
                    return this.index != -1;
                }

                @Override
                public boolean hasPrevious() {
                    return this.index != -1;
                }

                @Override
                public int next() {
                    int old = BitsetArrayIntVarImpl.this.values[this.index];
                    this.index = BitsetArrayIntVarImpl.this.indexes.nextSetBit(this.index + 1);
                    return old;
                }

                @Override
                public int previous() {
                    int old = BitsetArrayIntVarImpl.this.values[this.index];
                    this.index = BitsetArrayIntVarImpl.this.indexes.prevSetBit(this.index - 1);
                    return old;
                }
            };
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || !this._riterator.isReusable()) {
            this._riterator = new DisposableRangeIterator(){
                int from;
                int to;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.to = this.from = BitsetArrayIntVarImpl.this.indexes.nextSetBit(BitsetArrayIntVarImpl.this.LB.get());
                    while (BitsetArrayIntVarImpl.this.indexes.get(this.to + 1) && BitsetArrayIntVarImpl.this.values[this.to] == BitsetArrayIntVarImpl.this.values[this.to + 1] - 1) {
                        ++this.to;
                    }
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.from = this.to = BitsetArrayIntVarImpl.this.indexes.prevSetBit(BitsetArrayIntVarImpl.this.UB.get());
                    while (BitsetArrayIntVarImpl.this.indexes.get(this.from - 1) && BitsetArrayIntVarImpl.this.values[this.from - 1] == BitsetArrayIntVarImpl.this.values[this.from] - 1) {
                        --this.from;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.from != -1;
                }

                @Override
                public boolean hasPrevious() {
                    return this.to != -1;
                }

                @Override
                public void next() {
                    this.to = this.from = BitsetArrayIntVarImpl.this.indexes.nextSetBit(this.to + 1);
                    while (this.to > -1 && BitsetArrayIntVarImpl.this.indexes.get(this.to + 1) && BitsetArrayIntVarImpl.this.values[this.to] == BitsetArrayIntVarImpl.this.values[this.to + 1] - 1) {
                        ++this.to;
                    }
                }

                @Override
                public void previous() {
                    this.from = this.to = BitsetArrayIntVarImpl.this.indexes.prevSetBit(this.from - 1);
                    while (this.from > -1 && BitsetArrayIntVarImpl.this.indexes.get(this.from - 1) && BitsetArrayIntVarImpl.this.values[this.from - 1] == BitsetArrayIntVarImpl.this.values[this.from] - 1) {
                        --this.from;
                    }
                }

                @Override
                public int min() {
                    return BitsetArrayIntVarImpl.this.values[this.from];
                }

                @Override
                public int max() {
                    return BitsetArrayIntVarImpl.this.values[this.to];
                }
            };
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }
}

