/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import gnu.trove.map.hash.THashMap;
import java.util.BitSet;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateBitSet;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.explanations.antidom.AntiDomBitset;
import org.chocosolver.solver.explanations.antidom.AntiDomain;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.EnumDelta;
import org.chocosolver.solver.variables.delta.IEnumDelta;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.delta.monitor.EnumDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.tools.StringUtils;

public final class BitsetIntVarImpl
extends AbstractVariable
implements IntVar {
    private static final long serialVersionUID = 1L;
    protected boolean reactOnRemoval = false;
    private final IStateBitSet VALUES;
    private final IStateInt LB;
    private final IStateInt UB;
    private final IStateInt SIZE;
    private final int OFFSET;
    private final int LENGTH;
    private IEnumDelta delta = NoDelta.singleton;
    private DisposableValueIterator _viterator;
    private DisposableRangeIterator _riterator;

    public BitsetIntVarImpl(String name, int[] sortedValues, Solver solver) {
        super(name, solver);
        IEnvironment env = solver.getEnvironment();
        this.OFFSET = sortedValues[0];
        int capacity = sortedValues[sortedValues.length - 1] - this.OFFSET + 1;
        this.VALUES = env.makeBitSet(capacity);
        for (int i = 0; i < sortedValues.length; ++i) {
            this.VALUES.set(sortedValues[i] - this.OFFSET);
        }
        this.LB = env.makeInt(0);
        this.UB = env.makeInt(capacity - 1);
        this.SIZE = env.makeInt(this.VALUES.cardinality());
        this.LENGTH = capacity;
    }

    public BitsetIntVarImpl(String name, int offset, BitSet values, Solver solver) {
        super(name, solver);
        IEnvironment env = solver.getEnvironment();
        this.OFFSET = offset;
        int cardinality = values.cardinality();
        this.VALUES = env.makeBitSet(cardinality);
        int i = 0;
        while (i > -1) {
            this.VALUES.set(i);
            i = values.nextSetBit(i + 1);
        }
        this.LB = env.makeInt(0);
        this.UB = env.makeInt(this.VALUES.prevSetBit(this.VALUES.size()));
        this.SIZE = env.makeInt(cardinality);
        this.LENGTH = this.UB.get();
    }

    public BitsetIntVarImpl(String name, int min, int max, Solver solver) {
        super(name, solver);
        IEnvironment env = solver.getEnvironment();
        this.OFFSET = min;
        int capacity = max - min + 1;
        this.VALUES = env.makeBitSet(capacity);
        for (int i = 0; i <= max - min; ++i) {
            this.VALUES.set(i);
        }
        this.LB = env.makeInt(0);
        this.UB = env.makeInt(max - min);
        this.SIZE = env.makeInt(capacity);
        this.LENGTH = capacity;
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        boolean change;
        assert (cause != null);
        int aValue = value - this.OFFSET;
        boolean bl = change = aValue >= 0 && aValue <= this.LENGTH && this.VALUES.get(aValue);
        if (change) {
            if (this.SIZE.get() == 1) {
                if (this._plugexpl) {
                    this.solver.getExplainer().removeValue(this, value, cause);
                }
                this.contradiction(cause, IntEventType.REMOVE, "remove last value");
            }
            IntEventType e = IntEventType.REMOVE;
            this.VALUES.clear(aValue);
            this.SIZE.add(-1);
            if (this.reactOnRemoval) {
                this.delta.add(aValue + this.OFFSET, cause);
            }
            if (value == this.getLB()) {
                this.LB.set(this.VALUES.nextSetBit(aValue));
                e = IntEventType.INCLOW;
            } else if (value == this.getUB()) {
                this.UB.set(this.VALUES.prevSetBit(aValue));
                e = IntEventType.DECUPP;
            }
            assert (!this.VALUES.isEmpty());
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            this.notifyPropagators(e, cause);
            if (this._plugexpl) {
                this.solver.getExplainer().removeValue(this, value, cause);
            }
        }
        return change;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (from <= this.getLB()) {
            return this.updateLowerBound(to + 1, cause);
        }
        if (this.getUB() <= to) {
            return this.updateUpperBound(from - 1, cause);
        }
        boolean anyChange = false;
        int v = this.nextValue(from - 1);
        while (v <= to) {
            anyChange |= this.removeValue(v, cause);
            v = this.nextValue(v);
        }
        return anyChange;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (this.isInstantiated()) {
            int cvalue = this.getValue();
            if (value != cvalue) {
                if (this._plugexpl) {
                    this.solver.getExplainer().instantiateTo(this, value, cause, cvalue, cvalue);
                }
                this.contradiction(cause, IntEventType.INSTANTIATE, "already instantiated");
            }
            return false;
        }
        if (this.contains(value)) {
            int aValue = value - this.OFFSET;
            if (this.reactOnRemoval) {
                int i = this.VALUES.nextSetBit(this.LB.get());
                while (i < aValue) {
                    this.delta.add(i + this.OFFSET, cause);
                    i = this.VALUES.nextSetBit(i + 1);
                }
                i = this.VALUES.nextSetBit(aValue + 1);
                while (i >= 0) {
                    this.delta.add(i + this.OFFSET, cause);
                    i = this.VALUES.nextSetBit(i + 1);
                }
            }
            int oldLB = 0;
            int oldUB = 0;
            if (this._plugexpl) {
                oldLB = this.getLB();
                oldUB = this.getUB();
            }
            this.VALUES.clear();
            this.VALUES.set(aValue);
            this.LB.set(aValue);
            this.UB.set(aValue);
            this.SIZE.set(1);
            if (this.VALUES.isEmpty()) {
                this.contradiction(cause, IntEventType.INSTANTIATE, "empty domain");
            }
            if (this._plugexpl) {
                this.solver.getExplainer().instantiateTo(this, value, cause, oldLB, oldUB);
            }
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        if (this._plugexpl) {
            this.solver.getExplainer().instantiateTo(this, value, cause, this.getLB(), this.getUB());
        }
        this.contradiction(cause, IntEventType.INSTANTIATE, "unknown value");
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getLB();
        if (old < value) {
            int oub = this.getUB();
            if (oub < value) {
                if (this._plugexpl) {
                    this.solver.getExplainer().updateLowerBound(this, old, oub + 1, cause);
                }
                this.contradiction(cause, IntEventType.INCLOW, "new upper bound is lesser than lower bound");
            } else {
                IntEventType e = IntEventType.INCLOW;
                int aValue = value - this.OFFSET;
                if (this.reactOnRemoval) {
                    int i = old - this.OFFSET;
                    while (i < aValue) {
                        this.delta.add(i + this.OFFSET, cause);
                        i = this.VALUES.nextSetBit(i + 1);
                    }
                }
                this.VALUES.clear(old - this.OFFSET, aValue);
                this.LB.set(this.VALUES.nextSetBit(aValue));
                assert (this.SIZE.get() > this.VALUES.cardinality());
                this.SIZE.set(this.VALUES.cardinality());
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                if (this._plugexpl) {
                    this.solver.getExplainer().updateLowerBound(this, old, value, cause);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getUB();
        if (old > value) {
            int olb = this.getLB();
            if (olb > value) {
                if (this._plugexpl) {
                    this.solver.getExplainer().updateUpperBound(this, old, olb - 1, cause);
                }
                this.contradiction(cause, IntEventType.DECUPP, "new lower bound is greater than upper bound");
            } else {
                IntEventType e = IntEventType.DECUPP;
                int aValue = value - this.OFFSET;
                if (this.reactOnRemoval) {
                    int i = old - this.OFFSET;
                    while (i > aValue) {
                        this.delta.add(i + this.OFFSET, cause);
                        i = this.VALUES.prevSetBit(i - 1);
                    }
                }
                this.VALUES.clear(aValue + 1, old - this.OFFSET + 1);
                this.UB.set(this.VALUES.prevSetBit(aValue));
                assert (this.SIZE.get() > this.VALUES.cardinality());
                this.SIZE.set(this.VALUES.cardinality());
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                if (this._plugexpl) {
                    this.solver.getExplainer().updateUpperBound(this, old, value, cause);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void wipeOut(ICause cause) throws ContradictionException {
        assert (cause != null);
        this.removeInterval(this.getLB(), this.getUB(), cause);
    }

    @Override
    public boolean isInstantiated() {
        return this.SIZE.get() == 1;
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.isInstantiated() && this.contains(value);
    }

    @Override
    public boolean contains(int aValue) {
        return (aValue -= this.OFFSET) >= 0 && this.VALUES.get(aValue);
    }

    @Override
    public int getValue() {
        assert (this.isInstantiated()) : this.name + " not instantiated";
        return this.getLB();
    }

    @Override
    public int getLB() {
        return this.LB.get() + this.OFFSET;
    }

    @Override
    public int getUB() {
        return this.UB.get() + this.OFFSET;
    }

    @Override
    public int getDomainSize() {
        return this.SIZE.get();
    }

    @Override
    public int nextValue(int aValue) {
        int lb = this.LB.get();
        if ((aValue -= this.OFFSET) < 0 || aValue < lb) {
            return lb + this.OFFSET;
        }
        if ((aValue = this.VALUES.nextSetBit(aValue + 1)) > -1) {
            return aValue + this.OFFSET;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int previousValue(int aValue) {
        int ub = this.UB.get();
        if ((aValue -= this.OFFSET) > ub) {
            return ub + this.OFFSET;
        }
        if ((aValue = this.VALUES.prevSetBit(aValue - 1)) > -1) {
            return aValue + this.OFFSET;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return true;
    }

    @Override
    public IEnumDelta getDelta() {
        return this.delta;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(20);
        s.append(this.name).append(" = ");
        if (this.SIZE.get() == 1) {
            s.append(this.getLB());
        } else {
            int nb;
            s.append('{').append(this.getLB());
            int i = this.nextValue(this.getLB());
            for (nb = 5; i < Integer.MAX_VALUE && nb > 0; --nb) {
                s.append(',').append(i);
                i = this.nextValue(i);
            }
            if (nb == 0 && this.SIZE.get() > 6) {
                s.append("...,").append(this.getUB());
            }
            s.append('}');
        }
        return s.toString();
    }

    @Override
    public void createDelta() {
        if (!this.reactOnRemoval) {
            this.delta = new EnumDelta(this.solver.getSearchLoop());
            this.reactOnRemoval = true;
        }
    }

    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new EnumDeltaMonitor(this.delta, propagator);
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
        for (int i = this.mIdx - 1; i >= 0; --i) {
            this.monitors[i].onUpdate(this, event);
        }
    }

    @Override
    public AntiDomain antiDomain() {
        return new AntiDomBitset(this);
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, Explanation to) {
        AntiDomain invdom = xengine.getRemovedValues(this);
        DisposableValueIterator it = invdom.getValueIterator();
        while (it.hasNext()) {
            int val = it.next();
            if (!(what == VariableState.LB && val < this.getLB() || what == VariableState.UB && val > this.getUB()) && what != VariableState.DOM) continue;
            to.add(xengine.explain(this, val));
        }
        it.dispose();
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, int val, Explanation to) {
        to.add(xengine.explain(this, val));
    }

    @Override
    public void contradiction(ICause cause, IEventType event, String message) throws ContradictionException {
        assert (cause != null);
        this.solver.getEngine().fails(cause, this, message);
    }

    @Override
    public int getTypeAndKind() {
        return 9;
    }

    public IntVar duplicate() {
        return new BitsetIntVarImpl(StringUtils.randomName(this.name), this.OFFSET, this.VALUES.copyToBitSet(), this.getSolver());
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            BitsetIntVarImpl clone = new BitsetIntVarImpl(this.name, this.OFFSET, this.VALUES.copyToBitSet(), solver);
            identitymap.put(this, clone);
        }
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || !this._viterator.isReusable()) {
            this._viterator = new DisposableValueIterator(){
                int value;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.value = BitsetIntVarImpl.this.LB.get();
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.value = BitsetIntVarImpl.this.UB.get();
                }

                @Override
                public boolean hasNext() {
                    return this.value != -1;
                }

                @Override
                public boolean hasPrevious() {
                    return this.value != -1;
                }

                @Override
                public int next() {
                    int old = this.value;
                    this.value = BitsetIntVarImpl.this.VALUES.nextSetBit(this.value + 1);
                    return old + BitsetIntVarImpl.this.OFFSET;
                }

                @Override
                public int previous() {
                    int old = this.value;
                    this.value = BitsetIntVarImpl.this.VALUES.prevSetBit(this.value - 1);
                    return old + BitsetIntVarImpl.this.OFFSET;
                }
            };
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || !this._riterator.isReusable()) {
            this._riterator = new DisposableRangeIterator(){
                int from;
                int to;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.from = BitsetIntVarImpl.this.VALUES.nextSetBit(0);
                    this.to = BitsetIntVarImpl.this.VALUES.nextClearBit(this.from + 1) - 1;
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.to = BitsetIntVarImpl.this.VALUES.prevSetBit(BitsetIntVarImpl.this.VALUES.size() - 1);
                    this.from = BitsetIntVarImpl.this.VALUES.prevClearBit(this.to) + 1;
                }

                @Override
                public boolean hasNext() {
                    return this.from != -1;
                }

                @Override
                public boolean hasPrevious() {
                    return this.to != -1;
                }

                @Override
                public void next() {
                    this.from = BitsetIntVarImpl.this.VALUES.nextSetBit(this.to + 1);
                    this.to = BitsetIntVarImpl.this.VALUES.nextClearBit(this.from) - 1;
                }

                @Override
                public void previous() {
                    this.to = BitsetIntVarImpl.this.VALUES.prevSetBit(this.from - 1);
                    this.from = BitsetIntVarImpl.this.VALUES.prevClearBit(this.to) + 1;
                }

                @Override
                public int min() {
                    return this.from + BitsetIntVarImpl.this.OFFSET;
                }

                @Override
                public int max() {
                    return this.to + BitsetIntVarImpl.this.OFFSET;
                }
            };
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }
}

