/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.memory.structure.BasicIndexedBipartiteSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.explanations.antidom.AntiDomBool;
import org.chocosolver.solver.explanations.antidom.AntiDomain;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.solver.variables.VariableFactory;
import org.chocosolver.solver.variables.delta.IEnumDelta;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.delta.OneValueDelta;
import org.chocosolver.solver.variables.delta.monitor.OneValueDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.iterators.DisposableRangeBoundIterator;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueBoundIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.tools.StringUtils;

public final class BoolVarImpl
extends AbstractVariable
implements BoolVar {
    private static final long serialVersionUID = 1L;
    protected final int offset;
    protected int mValue;
    protected final BasicIndexedBipartiteSet notInstanciated;
    IEnumDelta delta = NoDelta.singleton;
    protected boolean reactOnRemoval = false;
    private DisposableValueIterator _viterator;
    private DisposableRangeIterator _riterator;
    private BoolVar not;
    private boolean isNot = false;

    public BoolVarImpl(String name, Solver solver) {
        super(name, solver);
        this.notInstanciated = solver.getEnvironment().getSharedBipartiteSetForBooleanVars();
        this.offset = this.notInstanciated.add();
        this.mValue = 0;
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (value == 0) {
            return this.instantiateTo(1, cause);
        }
        if (value == 1) {
            return this.instantiateTo(0, cause);
        }
        return false;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (from <= this.getLB()) {
            return this.updateLowerBound(to + 1, cause);
        }
        if (this.getUB() <= to) {
            return this.updateUpperBound(from - 1, cause);
        }
        boolean anyChange = false;
        int v = this.nextValue(from - 1);
        while (v <= to) {
            anyChange |= this.removeValue(v, cause);
            v = this.nextValue(v);
        }
        return anyChange;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (this.isInstantiated()) {
            int cvalue = this.getValue();
            if (value != cvalue) {
                if (this._plugexpl) {
                    this.solver.getExplainer().instantiateTo(this, value, cause, cvalue, cvalue);
                }
                this.contradiction(cause, IntEventType.INSTANTIATE, "already instantiated");
            }
            return false;
        }
        if (value == 0 || value == 1) {
            IntEventType e = IntEventType.INSTANTIATE;
            assert (this.notInstanciated.contains(this.offset));
            this.notInstanciated.swap(this.offset);
            if (this.reactOnRemoval) {
                this.delta.add(1 - value, cause);
            }
            this.mValue = value;
            if (this._plugexpl) {
                this.solver.getExplainer().instantiateTo(this, value, cause, 0, 1);
            }
            this.notifyPropagators(e, cause);
            return true;
        }
        if (this._plugexpl) {
            this.solver.getExplainer().instantiateTo(this, value, cause, 0, 1);
        }
        this.contradiction(cause, IntEventType.INSTANTIATE, "unknown value");
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        return value > 0 && this.instantiateTo(value, cause);
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        return value < 1 && this.instantiateTo(value, cause);
    }

    @Override
    public void wipeOut(ICause cause) throws ContradictionException {
        assert (cause != null);
        this.removeInterval(0, 1, cause);
    }

    @Override
    public boolean setToTrue(ICause cause) throws ContradictionException {
        assert (cause != null);
        return this.instantiateTo(1, cause);
    }

    @Override
    public boolean setToFalse(ICause cause) throws ContradictionException {
        assert (cause != null);
        return this.instantiateTo(0, cause);
    }

    @Override
    public boolean isInstantiated() {
        return !this.notInstanciated.contains(this.offset);
    }

    @Override
    public boolean isInstantiatedTo(int aValue) {
        return !this.notInstanciated.contains(this.offset) && this.mValue == aValue;
    }

    @Override
    public boolean contains(int aValue) {
        if (!this.notInstanciated.contains(this.offset)) {
            return this.mValue == aValue;
        }
        return aValue == 0 || aValue == 1;
    }

    @Override
    public int getValue() {
        return this.getLB();
    }

    @Override
    public ESat getBooleanValue() {
        if (this.isInstantiated()) {
            return ESat.eval(this.getLB() != 0);
        }
        return ESat.UNDEFINED;
    }

    @Override
    public int getLB() {
        if (!this.notInstanciated.contains(this.offset)) {
            return this.mValue;
        }
        return 0;
    }

    @Override
    public int getUB() {
        if (!this.notInstanciated.contains(this.offset)) {
            return this.mValue;
        }
        return 1;
    }

    @Override
    public int getDomainSize() {
        return this.notInstanciated.contains(this.offset) ? 2 : 1;
    }

    @Override
    public int nextValue(int v) {
        if (!this.notInstanciated.contains(this.offset)) {
            int val = this.mValue;
            return val > v ? val : Integer.MAX_VALUE;
        }
        if (v < 0) {
            return 0;
        }
        if (v == 0) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int previousValue(int v) {
        if (v > this.getUB()) {
            return this.getUB();
        }
        if (v > this.getLB()) {
            return this.getLB();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return true;
    }

    @Override
    public IEnumDelta getDelta() {
        return this.delta;
    }

    @Override
    public String toString() {
        if (!this.notInstanciated.contains(this.offset)) {
            return this.name + " = " + Integer.toString(this.mValue);
        }
        return this.name + " = " + "[0,1]";
    }

    @Override
    public void createDelta() {
        if (!this.reactOnRemoval) {
            this.delta = new OneValueDelta(this.solver.getSearchLoop());
            this.reactOnRemoval = true;
        }
    }

    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new OneValueDeltaMonitor(this.delta, propagator);
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
        for (int i = this.mIdx - 1; i >= 0; --i) {
            this.monitors[i].onUpdate(this, event);
        }
    }

    @Override
    public AntiDomain antiDomain() {
        return new AntiDomBool(this);
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, Explanation to) {
        AntiDomain invdom = xengine.getRemovedValues(this);
        DisposableValueIterator it = invdom.getValueIterator();
        while (it.hasNext()) {
            int val = it.next();
            if (!(what == VariableState.LB && val < this.getLB() || what == VariableState.UB && val > this.getUB()) && what != VariableState.DOM) continue;
            to.add(xengine.explain(this, val));
        }
        it.dispose();
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, int val, Explanation to) {
        to.add(xengine.explain(this, val));
    }

    @Override
    public void contradiction(ICause cause, IEventType event, String message) throws ContradictionException {
        assert (cause != null);
        this.solver.getEngine().fails(cause, this, message);
    }

    @Override
    public int getTypeAndKind() {
        return 25;
    }

    public BoolVar duplicate() {
        return VariableFactory.bool(StringUtils.randomName(this.name), this.getSolver());
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            BoolVarImpl clone = new BoolVarImpl(this.name, solver);
            identitymap.put(this, clone);
            if (this.not != null) {
                this.not.duplicate(solver, identitymap);
                clone._setNot((BoolVar)identitymap.get(this.not));
                clone.not._setNot(clone);
            }
        }
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || !this._viterator.isReusable()) {
            this._viterator = new DisposableValueBoundIterator(this);
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || !this._riterator.isReusable()) {
            this._riterator = new DisposableRangeBoundIterator(this);
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public void _setNot(BoolVar neg) {
        this.not = neg;
    }

    @Override
    public BoolVar not() {
        if (!this.hasNot()) {
            this.not = VF.not(this);
            this.not._setNot(this);
        }
        return this.not;
    }

    @Override
    public boolean hasNot() {
        return this.not != null;
    }

    @Override
    public boolean isLit() {
        return true;
    }

    @Override
    public boolean isNot() {
        return this.isNot;
    }

    @Override
    public void setNot(boolean isNot) {
        this.isNot = isNot;
    }
}

