/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.solver.variables.impl.FixedIntVarImpl;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.StringUtils;

public class FixedBoolVarImpl
extends FixedIntVarImpl
implements BoolVar {
    private static final long serialVersionUID = 1L;
    private BoolVar not;

    public FixedBoolVarImpl(String name, int constant, Solver solver) {
        super(name, constant, solver);
        assert (constant == 0 || constant == 1) : "FixedBoolVarImpl value should be taken in {0,1}";
    }

    @Override
    public int getTypeAndKind() {
        return 26;
    }

    @Override
    public ESat getBooleanValue() {
        return ESat.eval(this.constante == 1);
    }

    @Override
    public boolean setToTrue(ICause cause) throws ContradictionException {
        return this.instantiateTo(1, cause);
    }

    @Override
    public boolean setToFalse(ICause cause) throws ContradictionException {
        return this.instantiateTo(0, cause);
    }

    @Override
    public BoolVar not() {
        if (!this.hasNot()) {
            this.not = VF.not(this);
            this.not._setNot(this);
        }
        return this.not;
    }

    @Override
    public void _setNot(BoolVar not) {
        this.not = not;
    }

    @Override
    public boolean isLit() {
        return true;
    }

    @Override
    public boolean hasNot() {
        return this.not != null;
    }

    @Override
    public boolean isNot() {
        return this.constante == 0;
    }

    @Override
    public void setNot(boolean isNot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public IntVar duplicate() {
        return VF.fixed(StringUtils.randomName(), this.constante, this.getSolver());
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            identitymap.put(this, VF.fixed(this.name, this.constante, solver));
        }
    }
}

