/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.memory.IStateBool;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.explanations.antidom.AntiDomBitset;
import org.chocosolver.solver.explanations.antidom.AntiDomain;
import org.chocosolver.solver.variables.IVariableMonitor;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.view.IView;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.tools.StringUtils;

public class FixedIntVarImpl
extends AbstractVariable
implements IntVar {
    private static final long serialVersionUID = 1L;
    protected final int constante;
    protected IStateBool empty;
    private DisposableValueIterator _viterator;
    private DisposableRangeIterator _riterator;

    public FixedIntVarImpl(String name, int constante, Solver solver) {
        super(name, solver);
        this.constante = constante;
        this.empty = solver.getEnvironment().makeBool(false);
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        if (value == this.constante) {
            assert (cause != null);
            if (this._plugexpl) {
                this.solver.getExplainer().removeValue(this, this.constante, cause);
            }
            this.contradiction(cause, IntEventType.REMOVE, "unique value removal");
        }
        return false;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        if (from <= this.constante && this.constante <= to) {
            assert (cause != null);
            if (this._plugexpl) {
                this.solver.getExplainer().removeValue(this, this.constante, cause);
            }
            this.contradiction(cause, IntEventType.REMOVE, "unique value removal");
        }
        return false;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        if (value != this.constante) {
            assert (cause != null);
            if (this._plugexpl) {
                this.solver.getExplainer().removeValue(this, this.constante, cause);
            }
            this.contradiction(cause, IntEventType.INSTANTIATE, "outside domain instantitation");
        }
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        if (value > this.constante) {
            assert (cause != null);
            if (this._plugexpl) {
                this.solver.getExplainer().removeValue(this, this.constante, cause);
            }
            this.contradiction(cause, IntEventType.INCLOW, "outside domain update bound");
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        if (value < this.constante) {
            assert (cause != null);
            if (this._plugexpl) {
                this.solver.getExplainer().removeValue(this, this.constante, cause);
            }
            this.contradiction(cause, IntEventType.DECUPP, "outside domain update bound");
        }
        return false;
    }

    @Override
    public void wipeOut(ICause cause) throws ContradictionException {
        this.removeValue(this.constante, cause);
    }

    @Override
    public boolean contains(int value) {
        return this.constante == value;
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.constante == value;
    }

    @Override
    public int getValue() {
        return this.constante;
    }

    @Override
    public int getLB() {
        return this.constante;
    }

    @Override
    public int getUB() {
        return this.constante;
    }

    @Override
    public int getDomainSize() {
        return 1;
    }

    @Override
    public int nextValue(int v) {
        if (v < this.constante) {
            return this.constante;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int previousValue(int v) {
        if (v > this.constante) {
            return this.constante;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return true;
    }

    @Override
    public NoDelta getDelta() {
        return NoDelta.singleton;
    }

    @Override
    public boolean isInstantiated() {
        return true;
    }

    @Override
    public void addMonitor(IVariableMonitor monitor) {
    }

    @Override
    public AntiDomain antiDomain() {
        return new AntiDomBitset(this);
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, Explanation to) {
        if (this.empty.get()) {
            to.add(xengine.explain(this, this.constante));
        }
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, int val, Explanation to) {
        if (this.empty.get()) {
            to.add(xengine.explain(this, this.constante));
        }
    }

    @Override
    public void subscribeView(IView view) {
    }

    @Override
    public void recordMask(int mask) {
    }

    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        return IIntDeltaMonitor.Default.NONE;
    }

    @Override
    public void createDelta() {
    }

    @Override
    public void notifyPropagators(IEventType event, ICause cause) throws ContradictionException {
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
    }

    @Override
    public void notifyViews(IEventType event, ICause cause) throws ContradictionException {
    }

    @Override
    public String toString() {
        return this.name + " = " + String.valueOf(this.constante);
    }

    @Override
    public void contradiction(ICause cause, IEventType event, String message) throws ContradictionException {
        this.empty.set(true);
        this.solver.getEngine().fails(cause, this, message);
    }

    @Override
    public int getTypeAndKind() {
        return 10;
    }

    public IntVar duplicate() {
        return VF.fixed(StringUtils.randomName(), this.constante, this.getSolver());
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            identitymap.put(this, VF.fixed(this.name, this.constante, solver));
        }
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || !this._viterator.isReusable()) {
            this._viterator = new DisposableValueIterator(){
                boolean _next;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this._next = true;
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this._next = true;
                }

                @Override
                public boolean hasNext() {
                    return this._next;
                }

                @Override
                public boolean hasPrevious() {
                    return this._next;
                }

                @Override
                public int next() {
                    this._next = false;
                    return FixedIntVarImpl.this.constante;
                }

                @Override
                public int previous() {
                    this._next = false;
                    return FixedIntVarImpl.this.constante;
                }
            };
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || !this._riterator.isReusable()) {
            this._riterator = new DisposableRangeIterator(){
                boolean _next;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this._next = true;
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this._next = true;
                }

                @Override
                public boolean hasNext() {
                    return this._next;
                }

                @Override
                public boolean hasPrevious() {
                    return this._next;
                }

                @Override
                public void next() {
                    this._next = false;
                }

                @Override
                public void previous() {
                    this._next = false;
                }

                @Override
                public int min() {
                    return FixedIntVarImpl.this.constante;
                }

                @Override
                public int max() {
                    return FixedIntVarImpl.this.constante;
                }
            };
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }
}

