/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.IVariableMonitor;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.view.IView;
import org.chocosolver.util.tools.StringUtils;

public class FixedSetVarImpl
extends AbstractVariable
implements SetVar {
    private final int[] values;
    private int kerIndex;
    private int envIndex;

    public FixedSetVarImpl(String name, TIntSet values, Solver solver) {
        super(name, solver);
        this.values = values.toArray();
        Arrays.sort(this.values);
    }

    public FixedSetVarImpl(String name, int[] values, Solver solver) {
        this(name, new TIntHashSet(values), solver);
    }

    @Override
    public int getKernelFirst() {
        int n;
        if (this.values.length == 0) {
            n = Integer.MIN_VALUE;
        } else {
            this.kerIndex = 0;
            n = this.values[0];
        }
        return n;
    }

    @Override
    public int getKernelNext() {
        return ++this.kerIndex >= this.values.length ? Integer.MIN_VALUE : this.values[this.kerIndex];
    }

    @Override
    public int getKernelSize() {
        return this.values.length;
    }

    @Override
    public boolean kernelContains(int element) {
        return Arrays.binarySearch(this.values, element) >= 0;
    }

    @Override
    public int getEnvelopeFirst() {
        int n;
        if (this.values.length == 0) {
            n = Integer.MIN_VALUE;
        } else {
            this.envIndex = 0;
            n = this.values[0];
        }
        return n;
    }

    @Override
    public int getEnvelopeNext() {
        return ++this.envIndex >= this.values.length ? Integer.MIN_VALUE : this.values[this.envIndex];
    }

    @Override
    public int getEnvelopeSize() {
        return this.values.length;
    }

    @Override
    public boolean envelopeContains(int element) {
        return Arrays.binarySearch(this.values, element) >= 0;
    }

    @Override
    public boolean addToKernel(int element, ICause cause) throws ContradictionException {
        if (!this.kernelContains(element)) {
            this.contradiction(cause, SetEventType.ADD_TO_KER, "");
        }
        return false;
    }

    @Override
    public boolean removeFromEnvelope(int element, ICause cause) throws ContradictionException {
        if (this.envelopeContains(element)) {
            this.contradiction(cause, SetEventType.REMOVE_FROM_ENVELOPE, "");
        }
        return false;
    }

    @Override
    public boolean instantiateTo(int[] value, ICause cause) throws ContradictionException {
        if (value.length != this.values.length) {
            this.contradiction(cause, null, "");
        }
        for (int v : value) {
            if (this.kernelContains(v)) continue;
            this.contradiction(cause, null, "");
        }
        return false;
    }

    @Override
    public int[] getValues() {
        return this.values;
    }

    @Override
    public NoDelta getDelta() {
        return NoDelta.singleton;
    }

    @Override
    public void createDelta() {
    }

    @Override
    public ISetDeltaMonitor monitorDelta(ICause propagator) {
        return ISetDeltaMonitor.Default.NONE;
    }

    @Override
    public boolean isInstantiated() {
        return true;
    }

    @Override
    public void addMonitor(IVariableMonitor monitor) {
    }

    @Override
    public void removeMonitor(IVariableMonitor monitor) {
    }

    @Override
    public void subscribeView(IView view) {
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, Explanation to) {
        throw new UnsupportedOperationException("SetConstantView does not (yet) implement method explain(...)");
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, int val, Explanation to) {
        throw new UnsupportedOperationException("SetConstantView does not (yet) implement method explain(...)");
    }

    @Override
    public void recordMask(int mask) {
    }

    @Override
    public void notifyPropagators(IEventType event, ICause cause) throws ContradictionException {
    }

    @Override
    public void notifyViews(IEventType event, ICause cause) throws ContradictionException {
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
    }

    @Override
    public void contradiction(ICause cause, IEventType event, String message) throws ContradictionException {
        this.solver.getEngine().fails(cause, this, message);
    }

    @Override
    public int getTypeAndKind() {
        return 66;
    }

    public SetVar duplicate() {
        return new FixedSetVarImpl(StringUtils.randomName(), this.getValues(), this.getSolver());
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            FixedSetVarImpl clone = new FixedSetVarImpl(this.name, this.values, solver);
            identitymap.put(this, clone);
        }
    }
}

