/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.explanations.antidom.AntiDomInterval;
import org.chocosolver.solver.explanations.antidom.AntiDomain;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.IIntervalDelta;
import org.chocosolver.solver.variables.delta.IntervalDelta;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.delta.monitor.IntervalDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.util.iterators.DisposableRangeBoundIterator;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueBoundIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.tools.StringUtils;

public final class IntervalIntVarImpl
extends AbstractVariable
implements IntVar {
    private static final long serialVersionUID = 1L;
    protected boolean reactOnRemoval = false;
    private final IStateInt LB;
    private final IStateInt UB;
    private final IStateInt SIZE;
    IIntervalDelta delta = NoDelta.singleton;
    private DisposableValueIterator _viterator;
    private DisposableRangeIterator _riterator;

    public IntervalIntVarImpl(String name, int min, int max, Solver solver) {
        super(name, solver);
        IEnvironment env = solver.getEnvironment();
        this.LB = env.makeInt(min);
        this.UB = env.makeInt(max);
        this.SIZE = env.makeInt(max - min + 1);
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int inf = this.getLB();
        int sup = this.getUB();
        if (value == inf && value == sup) {
            if (this._plugexpl) {
                this.solver.getExplainer().removeValue(this, value, cause);
            }
            this.contradiction(cause, IntEventType.REMOVE, "remove last value");
        } else if (inf == value || value == sup) {
            IntEventType e;
            if (value == inf) {
                if (this.reactOnRemoval) {
                    this.delta.add(value, value, cause);
                }
                this.SIZE.add(-1);
                this.LB.set(value + 1);
                e = IntEventType.INCLOW;
            } else {
                if (this.reactOnRemoval) {
                    this.delta.add(value, value, cause);
                }
                this.SIZE.add(-1);
                this.UB.set(value - 1);
                e = IntEventType.DECUPP;
            }
            if (this.SIZE.get() > 0) {
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
            } else if (this.SIZE.get() == 0) {
                if (this._plugexpl) {
                    this.solver.getExplainer().removeValue(this, value, cause);
                }
                this.contradiction(cause, IntEventType.REMOVE, "empty domain");
            }
            if (this._plugexpl) {
                this.solver.getExplainer().removeValue(this, value, cause);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (from <= this.getLB()) {
            return this.updateLowerBound(to + 1, cause);
        }
        if (this.getUB() <= to) {
            return this.updateUpperBound(from - 1, cause);
        }
        return false;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (this.isInstantiated()) {
            int cvalue = this.getValue();
            if (value != cvalue) {
                if (this._plugexpl) {
                    this.solver.getExplainer().instantiateTo(this, value, cause, cvalue, cvalue);
                }
                this.contradiction(cause, IntEventType.INSTANTIATE, "already instantiated");
            }
            return false;
        }
        if (this.contains(value)) {
            IntEventType e = IntEventType.INSTANTIATE;
            int lb = 0;
            int ub = 0;
            if (this.reactOnRemoval) {
                lb = this.LB.get();
                ub = this.UB.get();
                if (lb <= value - 1) {
                    this.delta.add(lb, value - 1, cause);
                }
                if (value + 1 <= ub) {
                    this.delta.add(value + 1, ub, cause);
                }
            } else if (this._plugexpl) {
                lb = this.LB.get();
                ub = this.UB.get();
            }
            this.LB.set(value);
            this.UB.set(value);
            this.SIZE.set(1);
            if (this._plugexpl) {
                this.solver.getExplainer().instantiateTo(this, value, cause, lb, ub);
            }
            this.notifyPropagators(e, cause);
            return true;
        }
        if (this._plugexpl) {
            this.solver.getExplainer().instantiateTo(this, value, cause, this.LB.get(), this.UB.get());
        }
        this.contradiction(cause, IntEventType.INSTANTIATE, "unknown value");
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getLB();
        if (old < value) {
            int oub = this.getUB();
            if (oub < value) {
                if (this._plugexpl) {
                    this.solver.getExplainer().updateLowerBound(this, old, oub + 1, cause);
                }
                this.contradiction(cause, IntEventType.INCLOW, "new upper bound is lesser than lower bound");
            } else {
                IntEventType e = IntEventType.INCLOW;
                if (this.reactOnRemoval && old <= value - 1) {
                    this.delta.add(old, value - 1, cause);
                }
                this.SIZE.add(old - value);
                this.LB.set(value);
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                if (this._plugexpl) {
                    this.solver.getExplainer().updateLowerBound(this, old, value, cause);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getUB();
        if (old > value) {
            int olb = this.getLB();
            if (olb > value) {
                if (this._plugexpl) {
                    this.solver.getExplainer().updateUpperBound(this, old, olb - 1, cause);
                }
                this.contradiction(cause, IntEventType.DECUPP, "new lower bound is greater than upper bound");
            } else {
                IntEventType e = IntEventType.DECUPP;
                if (this.reactOnRemoval && value + 1 <= old) {
                    this.delta.add(value + 1, old, cause);
                }
                this.SIZE.add(value - old);
                this.UB.set(value);
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                if (this._plugexpl) {
                    this.solver.getExplainer().updateUpperBound(this, old, value, cause);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void wipeOut(ICause cause) throws ContradictionException {
        assert (cause != null);
        this.removeInterval(this.getLB(), this.getUB(), cause);
    }

    @Override
    public boolean isInstantiated() {
        return this.SIZE.get() == 1;
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.isInstantiated() && this.contains(value);
    }

    @Override
    public boolean contains(int aValue) {
        return aValue >= this.LB.get() && aValue <= this.UB.get();
    }

    @Override
    public int getValue() {
        assert (this.isInstantiated()) : this.name + " not instantiated";
        return this.getLB();
    }

    @Override
    public int getLB() {
        return this.LB.get();
    }

    @Override
    public int getUB() {
        return this.UB.get();
    }

    @Override
    public int getDomainSize() {
        return this.SIZE.get();
    }

    @Override
    public int nextValue(int aValue) {
        int lb = this.LB.get();
        if (aValue < lb) {
            return lb;
        }
        if (aValue < this.UB.get()) {
            return aValue + 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int previousValue(int aValue) {
        int ub = this.UB.get();
        if (aValue > ub) {
            return ub;
        }
        if (aValue > this.LB.get()) {
            return aValue - 1;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return false;
    }

    @Override
    public IIntervalDelta getDelta() {
        return this.delta;
    }

    @Override
    public String toString() {
        if (this.SIZE.get() == 1) {
            return String.format("%s = %d", this.name, this.getLB());
        }
        return String.format("%s = [%d,%d]", this.name, this.getLB(), this.getUB());
    }

    @Override
    public void createDelta() {
        if (!this.reactOnRemoval) {
            this.delta = new IntervalDelta(this.solver.getSearchLoop());
            this.reactOnRemoval = true;
        }
    }

    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new IntervalDeltaMonitor(this.delta, propagator);
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
        for (int i = this.mIdx - 1; i >= 0; --i) {
            this.monitors[i].onUpdate(this, event);
        }
    }

    @Override
    public AntiDomain antiDomain() {
        return new AntiDomInterval(this);
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, Explanation to) {
        AntiDomain invdom = xengine.getRemovedValues(this);
        DisposableValueIterator it = invdom.getValueIterator();
        while (it.hasNext()) {
            int val = it.next();
            if (!(what == VariableState.LB && val < this.getLB() || what == VariableState.UB && val > this.getUB()) && what != VariableState.DOM) continue;
            to.add(xengine.explain(this, val));
        }
        it.dispose();
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, int val, Explanation to) {
        to.add(xengine.explain(this, val));
    }

    @Override
    public void contradiction(ICause cause, IEventType event, String message) throws ContradictionException {
        assert (cause != null);
        this.solver.getEngine().fails(cause, this, message);
    }

    @Override
    public int getTypeAndKind() {
        return 9;
    }

    public IntVar duplicate() {
        return new IntervalIntVarImpl(StringUtils.randomName(this.name), this.LB.get(), this.UB.get(), this.getSolver());
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            IntervalIntVarImpl clone = new IntervalIntVarImpl(this.name, this.LB.get(), this.UB.get(), solver);
            identitymap.put(this, clone);
        }
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || !this._viterator.isReusable()) {
            this._viterator = new DisposableValueBoundIterator(this);
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || !this._riterator.isReusable()) {
            this._riterator = new DisposableRangeBoundIterator(this);
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }
}

