/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import gnu.trove.map.hash.THashMap;
import java.util.BitSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.delta.SetDelta;
import org.chocosolver.solver.variables.delta.monitor.SetDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.StringUtils;

public class SetVarImpl
extends AbstractVariable
implements SetVar {
    protected ISet envelope;
    protected ISet kernel;
    protected SetDelta delta;
    protected int min;
    protected int max;
    protected boolean reactOnModification;

    public SetVarImpl(String name, int[] env, SetType envType, int[] ker, SetType kerType, Solver solver) {
        super(name, solver);
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int i : env) {
            if (i == Integer.MIN_VALUE || i == Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("too large (infinite) integers within the set variable. Integer.MIN_VALUE and i==Integer.MAX_VALUE are not handled.");
            }
            min = Math.min(min, i);
            max = Math.max(max, i);
        }
        SetVarImpl.check(env, ker, max, min);
        this.envelope = SetFactory.makeStoredSet(envType, max - min + 1, solver);
        this.kernel = SetFactory.makeStoredSet(kerType, max - min + 1, solver);
        for (int i : env) {
            this.envelope.add(i - min);
        }
        for (int i : ker) {
            this.kernel.add(i - min);
        }
        this.min = min;
        this.max = max;
    }

    public SetVarImpl(String name, int min, int max, Solver solver) {
        super(name, solver);
        this.envelope = SetFactory.makeStoredSet(SetType.BITSET, max - min + 1, solver);
        this.kernel = SetFactory.makeStoredSet(SetType.BITSET, max - min + 1, solver);
        for (int i = min; i <= max; ++i) {
            this.envelope.add(i - min);
        }
        this.min = min;
        this.max = max;
    }

    private static void check(int[] env, int[] ker, int max, int min) {
        BitSet b = new BitSet(max - min);
        for (int i : env) {
            if (b.get(i - min)) {
                throw new UnsupportedOperationException("Invalid envelope definition. " + i + " is added twice.");
            }
            b.set(i - min);
        }
        for (int i : ker) {
            if (b.get(i - min)) continue;
            throw new UnsupportedOperationException("Invalid envelope/kernel definition. " + i + " is in the kernel but not in the envelope.");
        }
    }

    @Override
    public boolean isInstantiated() {
        return this.envelope.getSize() == this.kernel.getSize();
    }

    @Override
    public boolean addToKernel(int element, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (element < this.min || element > this.max || !this.envelope.contain(element - this.min)) {
            this.contradiction(cause, null, "");
            return true;
        }
        if (this.kernel.contain(element - this.min)) {
            return false;
        }
        this.kernel.add(element - this.min);
        if (this.reactOnModification) {
            this.delta.add(element, 0, cause);
        }
        SetEventType e = SetEventType.ADD_TO_KER;
        this.notifyPropagators(e, cause);
        return true;
    }

    @Override
    public boolean removeFromEnvelope(int element, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (element < this.min || element > this.max) {
            return false;
        }
        if (this.kernel.contain(element - this.min)) {
            this.contradiction(cause, SetEventType.REMOVE_FROM_ENVELOPE, "");
            return true;
        }
        if (!this.envelope.remove(element - this.min)) {
            return false;
        }
        if (this.reactOnModification) {
            this.delta.add(element, 1, cause);
        }
        SetEventType e = SetEventType.REMOVE_FROM_ENVELOPE;
        this.notifyPropagators(e, cause);
        return true;
    }

    @Override
    public boolean instantiateTo(int[] value, ICause cause) throws ContradictionException {
        boolean changed = !this.isInstantiated();
        for (int i : value) {
            this.addToKernel(i, cause);
        }
        if (this.kernel.getSize() != value.length) {
            this.contradiction(cause, null, "");
        }
        if (this.envelope.getSize() != value.length) {
            int i = this.getEnvelopeFirst();
            while (i != Integer.MIN_VALUE) {
                if (!this.kernelContains(i)) {
                    this.removeFromEnvelope(i, cause);
                }
                i = this.getEnvelopeNext();
            }
        }
        return changed;
    }

    @Override
    public int[] getValues() {
        int[] lb = new int[this.kernel.getSize()];
        int k = 0;
        int i = this.kernel.getFirstElement();
        while (i >= 0) {
            lb[k++] = i + this.min;
            i = this.kernel.getNextElement();
        }
        return lb;
    }

    @Override
    public int getKernelFirst() {
        int i = this.kernel.getFirstElement();
        return i == -1 ? Integer.MIN_VALUE : i + this.min;
    }

    @Override
    public int getKernelNext() {
        int i = this.kernel.getNextElement();
        return i == -1 ? Integer.MIN_VALUE : i + this.min;
    }

    @Override
    public int getKernelSize() {
        return this.kernel.getSize();
    }

    @Override
    public boolean kernelContains(int i) {
        return i >= this.min && i <= this.max && this.kernel.contain(i - this.min);
    }

    @Override
    public int getEnvelopeFirst() {
        int i = this.envelope.getFirstElement();
        return i == -1 ? Integer.MIN_VALUE : i + this.min;
    }

    @Override
    public int getEnvelopeNext() {
        int i = this.envelope.getNextElement();
        return i == -1 ? Integer.MIN_VALUE : i + this.min;
    }

    @Override
    public int getEnvelopeSize() {
        return this.envelope.getSize();
    }

    @Override
    public boolean envelopeContains(int i) {
        return i >= this.min && i <= this.max && this.envelope.contain(i - this.min);
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, Explanation to) {
        throw new UnsupportedOperationException("SetVar does not (yet) implement method explain(...)");
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, int val, Explanation to) {
        throw new UnsupportedOperationException("SetVar does not (yet) implement method explain(...)");
    }

    @Override
    public SetDelta getDelta() {
        return this.delta;
    }

    @Override
    public int getTypeAndKind() {
        return 65;
    }

    public SetVar duplicate() {
        int[] env = new int[this.getEnvelopeSize()];
        int idx = 0;
        int i = this.getEnvelopeFirst();
        while (i != Integer.MIN_VALUE) {
            env[idx++] = i;
            i = this.getEnvelopeNext();
        }
        int[] ker = new int[this.getKernelSize()];
        idx = 0;
        int i2 = this.getKernelFirst();
        while (i2 != Integer.MIN_VALUE) {
            ker[idx++] = i2;
            i2 = this.getKernelNext();
        }
        return new SetVarImpl(StringUtils.randomName(this.name), env, this.envelope.getSetType(), ker, this.kernel.getSetType(), this.solver);
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int[] env = new int[this.getEnvelopeSize()];
            int idx = 0;
            int i = this.getEnvelopeFirst();
            while (i != Integer.MIN_VALUE) {
                env[idx++] = i;
                i = this.getEnvelopeNext();
            }
            int[] ker = new int[this.getKernelSize()];
            idx = 0;
            int i2 = this.getKernelFirst();
            while (i2 != Integer.MIN_VALUE) {
                ker[idx++] = i2;
                i2 = this.getKernelNext();
            }
            SetVarImpl clone = new SetVarImpl(this.name, env, this.envelope.getSetType(), ker, this.kernel.getSetType(), solver);
            identitymap.put(this, clone);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" Envelope : {");
        int s = this.envelope.getSize();
        int i = this.envelope.getFirstElement();
        while (i >= 0) {
            sb.append(i + this.min);
            if (--s > 0) {
                sb.append(",");
            }
            i = this.envelope.getNextElement();
        }
        sb.append("} Kernel : {");
        s = this.kernel.getSize();
        i = this.kernel.getFirstElement();
        while (i >= 0) {
            sb.append(i + this.min);
            if (--s > 0) {
                sb.append(",");
            }
            i = this.kernel.getNextElement();
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void createDelta() {
        if (!this.reactOnModification) {
            this.reactOnModification = true;
            this.delta = new SetDelta(this.solver.getSearchLoop());
        }
    }

    @Override
    public SetDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new SetDeltaMonitor(this.delta, propagator);
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
        for (int i = this.mIdx - 1; i >= 0; --i) {
            this.monitors[i].onUpdate(this, event);
        }
    }

    @Override
    public void contradiction(ICause cause, IEventType event, String message) throws ContradictionException {
        assert (cause != null);
        this.solver.getEngine().fails(cause, this, message);
    }
}

