/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.view.EqView;
import org.chocosolver.util.ESat;

public final class BoolEqView
extends EqView
implements BoolVar {
    protected final BoolVar var;

    public BoolEqView(BoolVar var, Solver solver) {
        super(var, solver);
        this.var = var;
    }

    @Override
    public ESat getBooleanValue() {
        return this.var.getBooleanValue();
    }

    @Override
    public boolean setToTrue(ICause cause) throws ContradictionException {
        return this.instantiateTo(1, cause);
    }

    @Override
    public boolean setToFalse(ICause cause) throws ContradictionException {
        return this.instantiateTo(0, cause);
    }

    @Override
    public BoolVar duplicate() {
        return new BoolEqView(this.var, this.getSolver());
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.var.duplicate(solver, identitymap);
            BoolEqView clone = new BoolEqView((BoolVar)identitymap.get(this.var), solver);
            identitymap.put(this, clone);
        }
    }

    @Override
    public BoolVar not() {
        return this.var.not();
    }

    @Override
    public boolean hasNot() {
        return this.var.hasNot();
    }

    @Override
    public void _setNot(BoolVar not) {
        throw new SolverException("Unexpected call to BoolEqView._setNot()");
    }

    @Override
    public boolean isLit() {
        return true;
    }

    @Override
    public boolean isNot() {
        return this.var.isNot();
    }

    @Override
    public void setNot(boolean isNot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTypeAndKind() {
        return 28;
    }
}

