/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.VariableFactory;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.view.IntView;
import org.chocosolver.solver.variables.view.ViewDeltaMonitor;
import org.chocosolver.util.ESat;

public final class BoolNotView
extends IntView
implements BoolVar {
    protected final BoolVar var;

    public BoolNotView(BoolVar var, Solver solver) {
        super("not(" + var.getName() + ")", var, solver);
        this.var = var;
    }

    @Override
    public ESat getBooleanValue() {
        return ESat.not(this.var.getBooleanValue());
    }

    @Override
    public boolean setToTrue(ICause cause) throws ContradictionException {
        if (this.var.setToFalse(this)) {
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean setToFalse(ICause cause) throws ContradictionException {
        if (this.var.setToTrue(this)) {
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        if (this.var.removeValue(1 - value, this)) {
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        if (from <= this.getLB()) {
            return this.updateLowerBound(to + 1, cause);
        }
        if (this.getUB() <= to) {
            return this.updateUpperBound(from - 1, cause);
        }
        if (this.hasEnumeratedDomain()) {
            boolean anyChange = false;
            int v = this.nextValue(from - 1);
            while (v <= to) {
                anyChange |= this.removeValue(v, cause);
                v = this.nextValue(v);
            }
            return anyChange;
        }
        return false;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        if (this.var.instantiateTo(1 - value, this)) {
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        if (value > 0 && this.var.instantiateTo(1 - value, this)) {
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        if (value < 1 && this.var.instantiateTo(1 - value, this)) {
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(int value) {
        return this.var.contains(1 - value);
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.var.isInstantiatedTo(1 - value);
    }

    @Override
    public int getValue() {
        int v = this.var.getValue();
        return 1 - v;
    }

    @Override
    public int getLB() {
        if (this.var.isInstantiated()) {
            return this.getValue();
        }
        return 0;
    }

    @Override
    public int getUB() {
        if (this.var.isInstantiated()) {
            return this.getValue();
        }
        return 1;
    }

    @Override
    public int nextValue(int v) {
        if (v < 0 && this.contains(0)) {
            return 0;
        }
        return v <= 0 && this.contains(1) ? 1 : Integer.MAX_VALUE;
    }

    @Override
    public int previousValue(int v) {
        if (v > 1 && this.contains(1)) {
            return 1;
        }
        return v >= 1 && this.contains(0) ? 0 : Integer.MIN_VALUE;
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, int val, Explanation to) {
        this.var.explain(xengine, what, val, to);
    }

    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.var.createDelta();
        if (this.var.getDelta() == NoDelta.singleton) {
            return IIntDeltaMonitor.Default.NONE;
        }
        return new ViewDeltaMonitor((IIntDeltaMonitor)this.var.monitorDelta(propagator), propagator){

            @Override
            protected int transform(int value) {
                return 1 - value;
            }
        };
    }

    @Override
    public String toString() {
        return "not(" + this.var.getName() + ")";
    }

    public BoolVar duplicate() {
        return VariableFactory.not(this.var);
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.var.duplicate(solver, identitymap);
            BoolNotView clone = new BoolNotView((BoolVar)identitymap.get(this.var), solver);
            identitymap.put(this, clone);
        }
    }

    @Override
    public BoolVar not() {
        return this.var;
    }

    @Override
    public void _setNot(BoolVar not) {
        assert (not == this.var);
    }

    @Override
    public boolean hasNot() {
        return true;
    }

    @Override
    public boolean isLit() {
        return true;
    }

    @Override
    public boolean isNot() {
        return !this.var.isNot();
    }

    @Override
    public void setNot(boolean isNot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTypeAndKind() {
        return 28;
    }
}

