/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VariableFactory;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.view.IntView;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;

public class EqView
extends IntView {
    public EqView(IntVar var, Solver solver) {
        super("eq(" + var.getName() + ")", var, solver);
    }

    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        return this.var.monitorDelta(propagator);
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int inf = this.getLB();
        int sup = this.getUB();
        if (inf <= value && value <= sup) {
            IntEventType e = IntEventType.REMOVE;
            boolean done = this.var.removeValue(value, this);
            if (done) {
                if (value == inf) {
                    e = IntEventType.INCLOW;
                } else if (value == sup) {
                    e = IntEventType.DECUPP;
                }
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (from <= this.getLB()) {
            return this.updateLowerBound(to + 1, cause);
        }
        if (this.getUB() <= to) {
            return this.updateUpperBound(from - 1, cause);
        }
        boolean done = this.var.removeInterval(from, to, this);
        if (done) {
            this.notifyPropagators(IntEventType.REMOVE, cause);
        }
        return done;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        boolean done = this.var.instantiateTo(value, this);
        if (done) {
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getLB();
        if (old < value) {
            IntEventType e = IntEventType.INCLOW;
            boolean done = this.var.updateLowerBound(value, this);
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            if (done) {
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getUB();
        if (old > value) {
            IntEventType e = IntEventType.DECUPP;
            boolean done = this.var.updateUpperBound(value, this);
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            if (done) {
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(int value) {
        return this.var.contains(value);
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.var.isInstantiatedTo(value);
    }

    @Override
    public int getValue() {
        return this.var.getValue();
    }

    @Override
    public int getLB() {
        return this.var.getLB();
    }

    @Override
    public int getUB() {
        return this.var.getUB();
    }

    @Override
    public int nextValue(int v) {
        return this.var.nextValue(v);
    }

    @Override
    public int previousValue(int v) {
        return this.var.previousValue(v);
    }

    @Override
    public String toString() {
        return "eq(" + this.var.toString() + ") = [" + this.getLB() + "," + this.getUB() + "]";
    }

    public IntVar duplicate() {
        return VariableFactory.eq(this.var);
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.var.duplicate(solver, identitymap);
            EqView clone = new EqView((IntVar)identitymap.get(this.var), solver);
            identitymap.put(this, clone);
        }
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, int val, Explanation to) {
        this.var.explain(xengine, what, val, to);
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        return this.var.getValueIterator(bottomUp);
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        return this.var.getRangeIterator(bottomUp);
    }
}

