/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.explanations.antidom.AntiDomBitset;
import org.chocosolver.solver.explanations.antidom.AntiDomain;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IDelta;
import org.chocosolver.solver.variables.delta.IntDelta;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.view.IView;
import org.chocosolver.util.iterators.DisposableRangeBoundIterator;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueBoundIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;

public abstract class IntView
extends AbstractVariable
implements IView,
IntVar {
    protected final IntVar var;
    protected IntDelta delta;
    protected DisposableValueIterator _viterator;
    protected DisposableRangeIterator _riterator;

    public IntView(String name, IntVar var, Solver solver) {
        super(name, solver);
        this.var = var;
        this.delta = NoDelta.singleton;
        this.var.subscribeView(this);
    }

    @Override
    public final void recordMask(int mask) {
        super.recordMask(mask);
        this.var.recordMask(mask);
    }

    @Override
    public int getTypeAndKind() {
        return 12;
    }

    @Override
    public IntVar getVariable() {
        return this.var;
    }

    @Override
    public int getDomainSize() {
        return this.var.getDomainSize();
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return this.var.hasEnumeratedDomain();
    }

    @Override
    public boolean isInstantiated() {
        return this.var.isInstantiated();
    }

    @Override
    public IDelta getDelta() {
        return this.var.getDelta();
    }

    @Override
    public void createDelta() {
        this.var.createDelta();
    }

    @Override
    public int compareTo(Variable o) {
        return this.getId() - o.getId();
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
        for (int i = this.mIdx - 1; i >= 0; --i) {
            this.monitors[i].onUpdate(this, event);
        }
    }

    @Override
    public void transformEvent(IEventType evt, ICause cause) throws ContradictionException {
        this.notifyPropagators(evt, this);
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, Explanation to) {
        this.var.explain(xengine, what, to);
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        this.var.explain(xengine, VariableState.DOM, e);
    }

    @Override
    public AntiDomain antiDomain() {
        return new AntiDomBitset(this);
    }

    @Override
    public void contradiction(ICause cause, IEventType event, String message) throws ContradictionException {
        assert (cause != null);
        this.solver.getEngine().fails(cause, this, message);
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || !this._viterator.isReusable()) {
            this._viterator = new DisposableValueBoundIterator(this);
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || !this._riterator.isReusable()) {
            this._riterator = new DisposableRangeBoundIterator(this);
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public void wipeOut(ICause cause) throws ContradictionException {
        assert (cause != null);
        this.var.wipeOut(cause);
    }
}

