/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VariableFactory;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.view.IntView;
import org.chocosolver.solver.variables.view.ViewDeltaMonitor;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;

public class MinusView
extends IntView {
    public MinusView(IntVar var, Solver solver) {
        super("-(" + var.getName() + ")", var, solver);
    }

    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.var.createDelta();
        if (this.var.getDelta() == NoDelta.singleton) {
            return IIntDeltaMonitor.Default.NONE;
        }
        return new ViewDeltaMonitor((IIntDeltaMonitor)this.var.monitorDelta(propagator), propagator){

            @Override
            protected int transform(int value) {
                return -value;
            }
        };
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        int inf = this.getLB();
        int sup = this.getUB();
        if (inf <= value && value <= sup) {
            IntEventType e = IntEventType.REMOVE;
            boolean done = this.var.removeValue(-value, this);
            if (value == inf) {
                e = IntEventType.INCLOW;
            } else if (value == sup) {
                e = IntEventType.DECUPP;
            }
            if (done) {
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        if (from <= this.getLB()) {
            return this.updateLowerBound(to + 1, cause);
        }
        if (this.getUB() <= to) {
            return this.updateUpperBound(from - 1, cause);
        }
        boolean done = this.var.removeInterval(-to, -from, this);
        if (done) {
            this.notifyPropagators(IntEventType.REMOVE, cause);
        }
        return done;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        boolean done = this.var.instantiateTo(-value, this);
        if (done) {
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        int old = this.getLB();
        if (old < value) {
            IntEventType e = IntEventType.INCLOW;
            boolean done = this.var.updateUpperBound(-value, this);
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            if (done) {
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        int old = this.getUB();
        if (old > value) {
            IntEventType e = IntEventType.DECUPP;
            boolean done = this.var.updateLowerBound(-value, this);
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            if (done) {
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(int value) {
        return this.var.contains(-value);
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.var.isInstantiatedTo(-value);
    }

    @Override
    public int getValue() {
        return -this.var.getValue();
    }

    @Override
    public int getLB() {
        return -this.var.getUB();
    }

    @Override
    public int getUB() {
        return -this.var.getLB();
    }

    @Override
    public int nextValue(int v) {
        int value = this.var.previousValue(-v);
        if (value == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -value;
    }

    @Override
    public int previousValue(int v) {
        int value = this.var.nextValue(-v);
        if (value == Integer.MAX_VALUE) {
            return Integer.MIN_VALUE;
        }
        return -value;
    }

    @Override
    public String toString() {
        return "-(" + this.var.toString() + ") = [" + this.getLB() + "," + this.getUB() + "]";
    }

    public IntVar duplicate() {
        return VariableFactory.minus(this.var);
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.var.duplicate(solver, identitymap);
            MinusView clone = new MinusView((IntVar)identitymap.get(this.var), solver);
            identitymap.put(this, clone);
        }
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, Explanation to) {
        switch (what) {
            case UB: {
                this.var.explain(xengine, VariableState.LB, to);
                break;
            }
            case LB: {
                this.var.explain(xengine, VariableState.UB, to);
                break;
            }
            default: {
                this.var.explain(xengine, what, to);
            }
        }
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, int val, Explanation to) {
        this.var.explain(xengine, what, -val, to);
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || !this._viterator.isReusable()) {
            this._viterator = new DisposableValueIterator(){
                DisposableValueIterator vit;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.vit = MinusView.this.var.getValueIterator(false);
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.vit = MinusView.this.var.getValueIterator(true);
                }

                @Override
                public boolean hasNext() {
                    return this.vit.hasPrevious();
                }

                @Override
                public boolean hasPrevious() {
                    return this.vit.hasNext();
                }

                @Override
                public int next() {
                    return -this.vit.previous();
                }

                @Override
                public int previous() {
                    return -this.vit.next();
                }

                @Override
                public void dispose() {
                    super.dispose();
                    this.vit.dispose();
                }
            };
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || !this._riterator.isReusable()) {
            this._riterator = new DisposableRangeIterator(){
                DisposableRangeIterator vir;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.vir = MinusView.this.var.getRangeIterator(false);
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.vir = MinusView.this.var.getRangeIterator(true);
                }

                @Override
                public boolean hasNext() {
                    return this.vir.hasPrevious();
                }

                @Override
                public boolean hasPrevious() {
                    return this.vir.hasNext();
                }

                @Override
                public void next() {
                    this.vir.previous();
                }

                @Override
                public void previous() {
                    this.vir.next();
                }

                @Override
                public int min() {
                    return -this.vir.max();
                }

                @Override
                public int max() {
                    return -this.vir.min();
                }

                @Override
                public void dispose() {
                    super.dispose();
                    this.vir.dispose();
                }
            };
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public void transformEvent(IEventType evt, ICause cause) throws ContradictionException {
        if (evt == IntEventType.INCLOW) {
            evt = IntEventType.DECUPP;
        } else if (evt == IntEventType.DECUPP) {
            evt = IntEventType.INCLOW;
        }
        this.notifyPropagators(evt, this);
    }
}

