/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VariableFactory;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.view.IntView;
import org.chocosolver.solver.variables.view.ViewDeltaMonitor;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;

public final class OffsetView
extends IntView {
    public final int cste;

    public OffsetView(IntVar var, int cste, Solver solver) {
        super("(" + var.getName() + "+" + cste + ")", var, solver);
        this.cste = cste;
    }

    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.var.createDelta();
        if (this.var.getDelta() == NoDelta.singleton) {
            return IIntDeltaMonitor.Default.NONE;
        }
        return new ViewDeltaMonitor((IIntDeltaMonitor)this.var.monitorDelta(propagator), propagator){

            @Override
            protected int transform(int value) {
                return value + OffsetView.this.cste;
            }
        };
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int inf = this.getLB();
        int sup = this.getUB();
        if (inf <= value && value <= sup) {
            IntEventType e = IntEventType.REMOVE;
            boolean done = this.var.removeValue(value - this.cste, this);
            if (done) {
                if (value == inf) {
                    e = IntEventType.INCLOW;
                } else if (value == sup) {
                    e = IntEventType.DECUPP;
                }
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (from <= this.getLB()) {
            return this.updateLowerBound(to + 1, cause);
        }
        if (this.getUB() <= to) {
            return this.updateUpperBound(from - 1, cause);
        }
        boolean done = this.var.removeInterval(from - this.cste, to - this.cste, this);
        if (done) {
            this.notifyPropagators(IntEventType.REMOVE, cause);
        }
        return done;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        boolean done = this.var.instantiateTo(value - this.cste, this);
        if (done) {
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getLB();
        if (old < value) {
            IntEventType e = IntEventType.INCLOW;
            boolean done = this.var.updateLowerBound(value - this.cste, this);
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            if (done) {
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getUB();
        if (old > value) {
            IntEventType e = IntEventType.DECUPP;
            boolean done = this.var.updateUpperBound(value - this.cste, this);
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            if (done) {
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(int value) {
        return this.var.contains(value - this.cste);
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.var.isInstantiatedTo(value - this.cste);
    }

    @Override
    public int getValue() {
        return this.var.getValue() + this.cste;
    }

    @Override
    public int getLB() {
        return this.var.getLB() + this.cste;
    }

    @Override
    public int getUB() {
        return this.var.getUB() + this.cste;
    }

    @Override
    public int nextValue(int v) {
        int value = this.var.nextValue(v - this.cste);
        if (value == Integer.MAX_VALUE) {
            return value;
        }
        return value + this.cste;
    }

    @Override
    public int previousValue(int v) {
        int value = this.var.previousValue(v - this.cste);
        if (value == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return value + this.cste;
    }

    @Override
    public String toString() {
        return "(" + this.var.toString() + " + " + this.cste + ") = [" + this.getLB() + "," + this.getUB() + "]";
    }

    public IntVar duplicate() {
        return VariableFactory.offset(this.var, this.cste);
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.var.duplicate(solver, identitymap);
            OffsetView clone = new OffsetView((IntVar)identitymap.get(this.var), this.cste, solver);
            identitymap.put(this, clone);
        }
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, int val, Explanation to) {
        this.var.explain(xengine, what, val - this.cste, to);
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || !this._viterator.isReusable()) {
            this._viterator = new DisposableValueIterator(){
                DisposableValueIterator vit;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.vit = OffsetView.this.var.getValueIterator(true);
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.vit = OffsetView.this.var.getValueIterator(false);
                }

                @Override
                public boolean hasNext() {
                    return this.vit.hasNext();
                }

                @Override
                public boolean hasPrevious() {
                    return this.vit.hasPrevious();
                }

                @Override
                public int next() {
                    return this.vit.next() + OffsetView.this.cste;
                }

                @Override
                public int previous() {
                    return this.vit.previous() + OffsetView.this.cste;
                }

                @Override
                public void dispose() {
                    super.dispose();
                    this.vit.dispose();
                }
            };
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || !this._riterator.isReusable()) {
            this._riterator = new DisposableRangeIterator(){
                DisposableRangeIterator vir;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.vir = OffsetView.this.var.getRangeIterator(true);
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.vir = OffsetView.this.var.getRangeIterator(false);
                }

                @Override
                public boolean hasNext() {
                    return this.vir.hasNext();
                }

                @Override
                public boolean hasPrevious() {
                    return this.vir.hasPrevious();
                }

                @Override
                public void next() {
                    this.vir.next();
                }

                @Override
                public void previous() {
                    this.vir.previous();
                }

                @Override
                public int min() {
                    return this.vir.min() + OffsetView.this.cste;
                }

                @Override
                public int max() {
                    return this.vir.max() + OffsetView.this.cste;
                }

                @Override
                public void dispose() {
                    super.dispose();
                    this.vir.dispose();
                }
            };
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }
}

