/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.VariableFactory;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.RealEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.view.IView;

public class RealView
extends AbstractVariable
implements IView,
RealVar {
    protected final IntVar var;
    protected final double precision;

    public RealView(IntVar var, double precision) {
        super("(real)" + var.getName(), var.getSolver());
        this.var = var;
        this.precision = precision;
        this.var.subscribeView(this);
    }

    @Override
    public IntVar getVariable() {
        return this.var;
    }

    @Override
    public void transformEvent(IEventType evt, ICause cause) throws ContradictionException {
        RealEventType realevt;
        IntEventType intevt = (IntEventType)evt;
        switch (intevt) {
            case INSTANTIATE: 
            case BOUND: {
                realevt = RealEventType.BOUND;
                break;
            }
            case INCLOW: {
                realevt = RealEventType.INCLOW;
                break;
            }
            case DECUPP: {
                realevt = RealEventType.DECUPP;
                break;
            }
            case REMOVE: {
                return;
            }
            default: {
                throw new UnsupportedOperationException("unexpected event transformation in RealView");
            }
        }
        this.notifyPropagators(realevt, this);
    }

    @Override
    public void recordMask(int mask) {
        super.recordMask(mask);
        this.var.recordMask(mask);
    }

    @Override
    public String toString() {
        return "(real)" + this.var.toString();
    }

    @Override
    public double getLB() {
        return this.var.getLB();
    }

    @Override
    public double getUB() {
        return this.var.getUB();
    }

    @Override
    public boolean updateLowerBound(double value, ICause cause) throws ContradictionException {
        if (this.var.updateLowerBound((int)Math.ceil(value - this.precision), this)) {
            this.notifyPropagators(RealEventType.INCLOW, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(double value, ICause cause) throws ContradictionException {
        if (this.var.updateUpperBound((int)Math.floor(value + this.precision), this)) {
            this.notifyPropagators(RealEventType.INCLOW, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateBounds(double lowerbound, double upperbound, ICause cause) throws ContradictionException {
        int c = 0;
        c += this.var.updateLowerBound((int)Math.ceil(lowerbound - this.precision), this) ? 1 : 0;
        switch (c += this.var.updateUpperBound((int)Math.floor(upperbound + this.precision), this) ? 2 : 0) {
            case 3: {
                this.notifyPropagators(RealEventType.BOUND, cause);
                return true;
            }
            case 2: {
                this.notifyPropagators(RealEventType.DECUPP, cause);
                return true;
            }
            case 1: {
                this.notifyPropagators(RealEventType.INCLOW, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    @Override
    public boolean isInstantiated() {
        return this.var.isInstantiated();
    }

    @Override
    public NoDelta getDelta() {
        return NoDelta.singleton;
    }

    @Override
    public void createDelta() {
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
        for (int i = this.mIdx - 1; i >= 0; --i) {
            this.monitors[i].onUpdate(this, event);
        }
    }

    @Override
    public void contradiction(ICause cause, IEventType event, String message) throws ContradictionException {
        this.solver.getEngine().fails(cause, this, message);
    }

    @Override
    public int getTypeAndKind() {
        return 132;
    }

    public RealVar duplicate() {
        return VariableFactory.real(this.var, this.precision);
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.var.duplicate(solver, identitymap);
            RealView clone = new RealView((IntVar)identitymap.get(this.var), this.precision);
            identitymap.put(this, clone);
        }
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, Explanation to) {
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, int val, Explanation to) {
    }
}

