/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VariableFactory;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.view.IntView;
import org.chocosolver.solver.variables.view.ViewDeltaMonitor;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.tools.MathUtils;

public final class ScaleView
extends IntView {
    public final int cste;

    public ScaleView(IntVar var, int cste, Solver solver) {
        super("(" + var.getName() + "*" + cste + ")", var, solver);
        assert (cste > 0) : "view cste must be >0";
        this.cste = cste;
    }

    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.var.createDelta();
        if (this.var.getDelta() == NoDelta.singleton) {
            return IIntDeltaMonitor.Default.NONE;
        }
        return new ViewDeltaMonitor((IIntDeltaMonitor)this.var.monitorDelta(propagator), propagator){

            @Override
            protected int transform(int value) {
                return ScaleView.this.cste * value;
            }
        };
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (value % this.cste == 0) {
            int inf = this.getLB();
            int sup = this.getUB();
            if (inf <= value && value <= sup) {
                IntEventType e = IntEventType.REMOVE;
                boolean done = this.var.removeValue(value / this.cste, this);
                if (done) {
                    if (value == inf) {
                        e = IntEventType.INCLOW;
                    } else if (value == sup) {
                        e = IntEventType.DECUPP;
                    }
                    if (this.isInstantiated()) {
                        e = IntEventType.INSTANTIATE;
                    }
                    this.notifyPropagators(e, cause);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (from <= this.getLB()) {
            return this.updateLowerBound(to + 1, cause);
        }
        if (this.getUB() <= to) {
            return this.updateUpperBound(from - 1, cause);
        }
        boolean done = this.var.removeInterval(MathUtils.divCeil(from, this.cste), MathUtils.divFloor(to, this.cste), this);
        if (done) {
            this.notifyPropagators(IntEventType.REMOVE, cause);
        }
        return done;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        boolean done;
        assert (cause != null);
        if (value % this.cste != 0) {
            this.contradiction(cause, IntEventType.INSTANTIATE, "Not a multiple of " + this.cste);
        }
        if (done = this.var.instantiateTo(value / this.cste, this)) {
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getLB();
        if (old < value) {
            IntEventType e = IntEventType.INCLOW;
            boolean done = this.var.updateLowerBound(MathUtils.divCeil(value, this.cste), this);
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            if (done) {
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getUB();
        if (old > value) {
            IntEventType e = IntEventType.DECUPP;
            boolean done = this.var.updateUpperBound(MathUtils.divFloor(value, this.cste), this);
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            if (done) {
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(int value) {
        return value % this.cste == 0 && this.var.contains(value / this.cste);
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return value % this.cste == 0 && this.var.isInstantiatedTo(value / this.cste);
    }

    @Override
    public int getValue() {
        return this.var.getValue() * this.cste;
    }

    @Override
    public int getLB() {
        return this.var.getLB() * this.cste;
    }

    @Override
    public int getUB() {
        return this.var.getUB() * this.cste;
    }

    @Override
    public int nextValue(int v) {
        int value = this.var.nextValue(MathUtils.divFloor(v, this.cste));
        if (value == Integer.MAX_VALUE) {
            return value;
        }
        return value * this.cste;
    }

    @Override
    public int previousValue(int v) {
        int value = this.var.previousValue(MathUtils.divCeil(v, this.cste));
        if (value == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return value * this.cste;
    }

    @Override
    public String toString() {
        return "(" + this.var.toString() + " * " + this.cste + ") = [" + this.getLB() + "," + this.getUB() + "]";
    }

    public IntVar duplicate() {
        return VariableFactory.scale(this.var, this.cste);
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.var.duplicate(solver, identitymap);
            ScaleView clone = new ScaleView((IntVar)identitymap.get(this.var), this.cste, solver);
            identitymap.put(this, clone);
        }
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, int val, Explanation to) {
        this.var.explain(xengine, what, val / this.cste, to);
    }

    @Override
    public void explain(ExplanationEngine xengine, VariableState what, Explanation to) {
        if (this.cste > 0) {
            this.var.explain(xengine, what, to);
        } else {
            switch (what) {
                case UB: {
                    this.var.explain(xengine, VariableState.LB, to);
                    break;
                }
                case LB: {
                    this.var.explain(xengine, VariableState.UB, to);
                    break;
                }
                default: {
                    this.var.explain(xengine, what, to);
                }
            }
        }
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || !this._viterator.isReusable()) {
            this._viterator = new DisposableValueIterator(){
                DisposableValueIterator vit;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.vit = ScaleView.this.var.getValueIterator(true);
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.vit = ScaleView.this.var.getValueIterator(false);
                }

                @Override
                public boolean hasNext() {
                    return this.vit.hasNext();
                }

                @Override
                public boolean hasPrevious() {
                    return this.vit.hasPrevious();
                }

                @Override
                public int next() {
                    return this.vit.next() * ScaleView.this.cste;
                }

                @Override
                public int previous() {
                    return this.vit.previous() * ScaleView.this.cste;
                }

                @Override
                public void dispose() {
                    super.dispose();
                    this.vit.dispose();
                }
            };
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this.cste == 1) {
            return this.var.getRangeIterator(bottomUp);
        }
        if (this._riterator == null || !this._riterator.isReusable()) {
            this._riterator = new DisposableRangeIterator(){
                DisposableValueIterator vit;
                int min;
                int max;

                @Override
                public void bottomUpInit() {
                    this.vit = ScaleView.this.getValueIterator(true);
                    if (this.vit.hasNext()) {
                        this.min = this.vit.next();
                    }
                    this.max = this.min;
                }

                @Override
                public void topDownInit() {
                    this.vit = ScaleView.this.getValueIterator(false);
                    if (this.vit.hasPrevious()) {
                        this.max = this.vit.previous();
                    }
                    this.min = this.max;
                }

                @Override
                public boolean hasNext() {
                    return this.min != Integer.MAX_VALUE;
                }

                @Override
                public boolean hasPrevious() {
                    return this.max != -2147483647;
                }

                @Override
                public void next() {
                    this.min = this.vit.hasNext() ? (this.max = this.vit.next()) : Integer.MAX_VALUE;
                }

                @Override
                public void previous() {
                    if (this.vit.hasPrevious()) {
                        this.min = this.max = this.vit.previous();
                    } else {
                        this.max = -2147483647;
                    }
                }

                @Override
                public int min() {
                    return this.min;
                }

                @Override
                public int max() {
                    return this.max;
                }
            };
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }
}

