/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.SafeIntProcedure;

public abstract class ViewDeltaMonitor
implements IIntDeltaMonitor {
    IIntDeltaMonitor deltamonitor;
    protected ICause propagator;
    protected TIntArrayList values;
    protected Filler filler;

    public ViewDeltaMonitor(IIntDeltaMonitor deltamonitor, ICause propagator) {
        this.deltamonitor = deltamonitor;
        this.propagator = propagator;
        this.values = new TIntArrayList(8);
        this.filler = new Filler();
    }

    @Override
    public void freeze() {
        this.deltamonitor.freeze();
    }

    @Override
    public void unfreeze() {
        this.deltamonitor.unfreeze();
    }

    @Override
    public void forEachRemVal(SafeIntProcedure proc) {
        this.values.clear();
        this.deltamonitor.forEachRemVal(this.filler);
        for (int v = 0; v < this.values.size(); ++v) {
            proc.execute(this.transform(this.values.toArray()[v]));
        }
    }

    @Override
    public void forEachRemVal(IntProcedure proc) throws ContradictionException {
        this.values.clear();
        this.deltamonitor.forEachRemVal(this.filler);
        for (int v = 0; v < this.values.size(); ++v) {
            proc.execute(this.transform(this.values.toArray()[v]));
        }
    }

    protected abstract int transform(int var1);

    private class Filler
    implements SafeIntProcedure {
        private Filler() {
        }

        @Override
        public void execute(int i) {
            ViewDeltaMonitor.this.values.add(i);
        }
    }
}

