/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util;

import java.util.LinkedHashSet;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;

public enum VariableUtilities {


    public static BoolVar[] nonReundantVars(BoolVar[] v) {
        LinkedHashSet<BoolVar> nonRedundantBs = new LinkedHashSet<BoolVar>();
        for (int j = 0; j < v.length; ++j) {
            if (nonRedundantBs.contains(v[j])) continue;
            nonRedundantBs.add(v[j]);
        }
        return nonRedundantBs.toArray(new BoolVar[nonRedundantBs.size()]);
    }

    public static IntVar[] nonReundantVars(IntVar[] v) {
        LinkedHashSet<IntVar> nonRedundantBs = new LinkedHashSet<IntVar>();
        for (int j = 0; j < v.length; ++j) {
            if (nonRedundantBs.contains(v[j])) continue;
            nonRedundantBs.add(v[j]);
        }
        return nonRedundantBs.toArray(new IntVar[nonRedundantBs.size()]);
    }

    public static boolean emptyUnion(IntVar x, IntVar y) {
        if (x.getLB() <= y.getUB() && y.getLB() <= x.getUB()) {
            if (!y.hasEnumeratedDomain() || !x.hasEnumeratedDomain()) {
                return false;
            }
            int ub = y.getUB();
            int val = y.getLB();
            while (val <= ub) {
                if (x.contains(val)) {
                    return false;
                }
                val = y.nextValue(val);
            }
            return true;
        }
        return true;
    }
}

