/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.graphOperations.connectivity;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;

public class ConnectivityFinder {
    private int n;
    private IGraph graph;
    private int[] CC_firstNode;
    private int[] CC_nextNode;
    private int[] node_CC;
    private int[] p;
    private int[] fifo;
    private int nbCC;
    private int[] numOfNode;
    private int[] nodeOfNum;
    private int[] inf;
    public TIntArrayList isthmusFrom;
    public TIntArrayList isthmusTo;
    private int[] ND;
    private int[] L;
    private int[] H;

    public ConnectivityFinder(IGraph g) {
        this.graph = g;
        this.n = g.getNbMaxNodes();
        this.p = new int[this.n];
        this.fifo = new int[this.n];
    }

    public int getNBCC() {
        return this.nbCC;
    }

    public int[] getCC_firstNode() {
        return this.CC_firstNode;
    }

    public int[] getCC_nextNode() {
        return this.CC_nextNode;
    }

    public int[] getNode_CC() {
        return this.node_CC;
    }

    public void findAllCC() {
        if (this.node_CC == null) {
            this.CC_firstNode = new int[this.n];
            this.CC_nextNode = new int[this.n];
            this.node_CC = new int[this.n];
        }
        ISet act = this.graph.getNodes();
        int i = act.getFirstElement();
        while (i >= 0) {
            this.p[i] = -1;
            i = act.getNextElement();
        }
        for (i = 0; i < this.CC_firstNode.length; ++i) {
            this.CC_firstNode[i] = -1;
        }
        int first = act.getFirstElement();
        int cc = 0;
        while (first >= 0) {
            this.findCC(first, cc);
            ++cc;
            while (first >= 0 && this.p[first] != -1) {
                first = act.getNextElement();
            }
        }
        this.nbCC = cc;
    }

    private void findCC(int start, int cc) {
        int first = 0;
        int last = 0;
        this.fifo[last++] = start;
        this.p[start] = start;
        this.add(start, cc);
        while (first < last) {
            int i = this.fifo[first++];
            ISet s = this.graph.getSuccOrNeighOf(i);
            int j = s.getFirstElement();
            while (j >= 0) {
                if (this.p[j] == -1) {
                    this.p[j] = i;
                    this.add(j, cc);
                    this.fifo[last++] = j;
                }
                j = s.getNextElement();
            }
            if (!this.graph.isDirected()) continue;
            s = this.graph.getPredOrNeighOf(i);
            j = s.getFirstElement();
            while (j >= 0) {
                if (this.p[j] == -1) {
                    this.p[j] = i;
                    this.add(j, cc);
                    this.fifo[last++] = j;
                }
                j = s.getNextElement();
            }
        }
    }

    private void add(int node, int cc) {
        this.node_CC[node] = cc;
        this.CC_nextNode[node] = this.CC_firstNode[cc];
        this.CC_firstNode[cc] = node;
    }

    public boolean isBiconnected() {
        int k;
        int start;
        assert (!this.graph.isDirected());
        if (this.nodeOfNum == null) {
            this.nodeOfNum = new int[this.n];
            this.numOfNode = new int[this.n];
            this.inf = new int[this.n];
        }
        ISet act = this.graph.getNodes();
        int i = act.getFirstElement();
        while (i >= 0) {
            this.inf[i] = Integer.MAX_VALUE;
            this.p[i] = -1;
            i = act.getNextElement();
        }
        int i2 = start = act.getFirstElement();
        this.numOfNode[start] = k = 0;
        this.nodeOfNum[k] = start;
        this.p[start] = start;
        int nbRootChildren = 0;
        boolean first = true;
        while (true) {
            int j;
            if (first) {
                j = this.graph.getSuccOrNeighOf(i2).getFirstElement();
                first = false;
            } else {
                j = this.graph.getSuccOrNeighOf(i2).getNextElement();
            }
            if (j < 0) {
                if (i2 == start) {
                    return k >= act.getSize() - 1;
                }
                int q = this.inf[i2];
                i2 = this.p[i2];
                this.inf[i2] = Math.min(q, this.inf[i2]);
                if (q < this.numOfNode[i2] || i2 == start) continue;
                return false;
            }
            if (this.p[j] == -1) {
                this.p[j] = i2;
                if (i2 == start && ++nbRootChildren > 1) {
                    return false;
                }
                i2 = j;
                first = true;
                this.numOfNode[i2] = ++k;
                this.nodeOfNum[k] = i2;
                this.inf[i2] = this.numOfNode[i2];
                continue;
            }
            if (this.p[i2] == j) continue;
            this.inf[i2] = Math.min(this.inf[i2], this.numOfNode[j]);
        }
    }

    public boolean isConnectedAndFindIsthma() {
        int k;
        int start;
        assert (!this.graph.isDirected());
        if (this.numOfNode == null || this.CC_firstNode == null) {
            this.CC_firstNode = new int[this.n];
            this.CC_nextNode = new int[this.n];
            this.node_CC = new int[this.n];
            this.nodeOfNum = new int[this.n];
            this.numOfNode = new int[this.n];
            this.isthmusFrom = new TIntArrayList();
            this.isthmusTo = new TIntArrayList();
            this.ND = new int[this.n];
            this.L = new int[this.n];
            this.H = new int[this.n];
        }
        ISet act = this.graph.getNodes();
        int i = act.getFirstElement();
        while (i >= 0) {
            this.p[i] = -1;
            i = act.getNextElement();
        }
        for (i = 0; i < this.CC_firstNode.length; ++i) {
            this.CC_firstNode[i] = -1;
        }
        int i2 = start = act.getFirstElement();
        this.numOfNode[start] = k = 0;
        this.nodeOfNum[k] = start;
        this.p[start] = start;
        boolean first = true;
        while (true) {
            int j;
            if (first) {
                j = this.graph.getSuccOrNeighOf(i2).getFirstElement();
                first = false;
            } else {
                j = this.graph.getSuccOrNeighOf(i2).getNextElement();
            }
            if (j < 0) {
                if (i2 == start) {
                    if (k >= act.getSize() - 1) break;
                    return false;
                }
                i2 = this.p[i2];
                continue;
            }
            if (this.p[j] != -1) continue;
            this.p[j] = i2;
            i2 = j;
            first = true;
            this.add(i2, 0);
            this.numOfNode[i2] = ++k;
            this.nodeOfNum[k] = i2;
        }
        this.isthmusFrom.clear();
        this.isthmusTo.clear();
        for (i2 = k; i2 >= 0; --i2) {
            int currentNode = this.nodeOfNum[i2];
            this.ND[currentNode] = 1;
            this.L[currentNode] = i2;
            this.H[currentNode] = i2;
            ISet nei = this.graph.getSuccOrNeighOf(currentNode);
            int s = nei.getFirstElement();
            while (s >= 0) {
                if (this.p[s] == currentNode) {
                    int n = currentNode;
                    this.ND[n] = this.ND[n] + this.ND[s];
                    this.L[currentNode] = Math.min(this.L[currentNode], this.L[s]);
                    this.H[currentNode] = Math.max(this.H[currentNode], this.H[s]);
                } else if (s != this.p[currentNode]) {
                    this.L[currentNode] = Math.min(this.L[currentNode], this.numOfNode[s]);
                    this.H[currentNode] = Math.max(this.H[currentNode], this.numOfNode[s]);
                }
                if (s != currentNode && this.p[s] == currentNode && this.L[s] >= this.numOfNode[s] && this.H[s] < this.numOfNode[s] + this.ND[s]) {
                    this.isthmusFrom.add(currentNode);
                    this.isthmusTo.add(s);
                }
                s = nei.getNextElement();
            }
        }
        return true;
    }
}

