/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.graphOperations.connectivity;

import java.io.Serializable;
import java.util.BitSet;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;

public class StrongConnectivityFinder
implements Serializable {
    private DirectedGraph graph;
    private BitSet restriction;
    private int n;
    private int[] sccFirstNode;
    private int[] nextNode;
    private int[] nodeSCC;
    private int nbSCC;
    ISet[] successors;
    int[] stack;
    int[] p;
    int[] inf;
    int[] nodeOfDfsNum;
    int[] dfsNumOfNode;
    BitSet inStack;

    public StrongConnectivityFinder(DirectedGraph graph) {
        this.graph = graph;
        this.n = graph.getNbMaxNodes();
        this.stack = new int[this.n];
        this.p = new int[this.n];
        this.inf = new int[this.n];
        this.nodeOfDfsNum = new int[this.n];
        this.dfsNumOfNode = new int[this.n];
        this.inStack = new BitSet(this.n);
        this.successors = new ISet[this.n];
        this.restriction = new BitSet(this.n);
        this.sccFirstNode = new int[this.n];
        this.nextNode = new int[this.n];
        this.nodeSCC = new int[this.n];
        this.nbSCC = 0;
    }

    public void findAllSCC() {
        ISet nodes = this.graph.getNodes();
        for (int i = 0; i < this.n; ++i) {
            this.restriction.set(i, nodes.contain(i));
        }
        this.findAllSCCOf(this.restriction);
    }

    public void findAllSCCOf(BitSet restriction) {
        this.inStack.clear();
        for (int i = 0; i < this.n; ++i) {
            this.dfsNumOfNode[i] = 0;
            this.inf[i] = this.n + 2;
            this.nextNode[i] = -1;
            this.sccFirstNode[i] = -1;
            this.nodeSCC[i] = -1;
        }
        this.nbSCC = 0;
        this.findSingletons(restriction);
        int first = restriction.nextSetBit(0);
        while (first >= 0) {
            this.findSCC(first, restriction, this.stack, this.p, this.inf, this.nodeOfDfsNum, this.dfsNumOfNode, this.inStack);
            first = restriction.nextSetBit(first);
        }
    }

    private void findSingletons(BitSet restriction) {
        ISet nodes = this.graph.getNodes();
        int i = restriction.nextSetBit(0);
        while (i >= 0) {
            if (nodes.contain(i) && this.graph.getPredOf(i).getSize() * this.graph.getSuccOf(i).getSize() == 0) {
                this.nodeSCC[i] = this.nbSCC;
                this.sccFirstNode[this.nbSCC++] = i;
                restriction.clear(i);
            }
            i = restriction.nextSetBit(i + 1);
        }
    }

    private void findSCC(int start, BitSet restriction, int[] stack, int[] p, int[] inf, int[] nodeOfDfsNum, int[] dfsNumOfNode, BitSet inStack) {
        int y;
        int k;
        int nb = restriction.cardinality();
        if (nb == 1) {
            this.nodeSCC[start] = this.nbSCC;
            this.sccFirstNode[this.nbSCC++] = start;
            restriction.clear(start);
            return;
        }
        int stackIdx = 0;
        int i = k = 0;
        dfsNumOfNode[start] = k;
        nodeOfDfsNum[k] = start;
        stack[stackIdx++] = i;
        inStack.set(i);
        p[k] = k;
        this.successors[k] = this.graph.getSuccOf(start);
        boolean notFinished = true;
        boolean first = true;
        while (notFinished) {
            int j = first ? this.successors[i].getFirstElement() : this.successors[i].getNextElement();
            first = false;
            if (j >= 0) {
                if (!restriction.get(j)) continue;
                if (dfsNumOfNode[j] == 0 && j != start) {
                    nodeOfDfsNum[++k] = j;
                    dfsNumOfNode[j] = k;
                    p[k] = i;
                    i = k;
                    first = true;
                    this.successors[i] = this.graph.getSuccOf(j);
                    stack[stackIdx++] = i;
                    inStack.set(i);
                    inf[i] = i;
                    continue;
                }
                if (!inStack.get(dfsNumOfNode[j])) continue;
                inf[i] = Math.min(inf[i], dfsNumOfNode[j]);
                continue;
            }
            if (i == 0) {
                notFinished = false;
                break;
            }
            if (inf[i] >= i) {
                int z;
                do {
                    z = stack[--stackIdx];
                    inStack.clear(z);
                    y = nodeOfDfsNum[z];
                    restriction.clear(y);
                    this.sccAdd(y);
                } while (z != i);
                ++this.nbSCC;
            }
            inf[p[i]] = Math.min(inf[p[i]], inf[i]);
            i = p[i];
        }
        if (inStack.cardinality() > 0) {
            do {
                y = nodeOfDfsNum[stack[--stackIdx]];
                restriction.clear(y);
                this.sccAdd(y);
            } while (y != start);
            ++this.nbSCC;
        }
    }

    private void sccAdd(int y) {
        this.nodeSCC[y] = this.nbSCC;
        this.nextNode[y] = this.sccFirstNode[this.nbSCC];
        this.sccFirstNode[this.nbSCC] = y;
    }

    public int getNbSCC() {
        return this.nbSCC;
    }

    public int[] getNodesSCC() {
        return this.nodeSCC;
    }

    public int getSCCFirstNode(int i) {
        return this.sccFirstNode[i];
    }

    public int getNextNode(int j) {
        return this.nextNode[j];
    }
}

