/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.graphOperations.dominance;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetType;

public abstract class AbstractLengauerTarjanDominatorsFinder {
    protected DirectedGraph g;
    protected DirectedGraph T;
    protected int root;
    protected int n;
    protected int k;
    protected int[] parent;
    protected int[] vertex;
    protected int[] bucket;
    protected int[] ancestor;
    protected int[] label;
    protected int[] semi;
    protected int[] dom;
    protected ISet[] succs;
    protected ISet[] preds;
    protected TIntArrayList list;

    public AbstractLengauerTarjanDominatorsFinder(int s, DirectedGraph g) {
        this.root = s;
        this.n = g.getNbMaxNodes();
        this.g = g;
        this.parent = new int[this.n];
        this.semi = new int[this.n];
        this.dom = new int[this.n];
        this.ancestor = new int[this.n];
        this.label = new int[this.n];
        this.vertex = new int[this.n];
        this.bucket = new int[this.n];
        this.succs = new ISet[this.n];
        this.preds = new ISet[this.n];
        this.T = new DirectedGraph(this.n, SetType.LINKED_LIST, false);
        this.list = new TIntArrayList();
    }

    public boolean findDominators() {
        this.initParams(false);
        this.DFS();
        if (this.k != this.n - 1) {
            return false;
        }
        this.findAllIdom();
        this.preprocessDominanceRequests();
        return true;
    }

    public boolean findPostDominators() {
        this.initParams(true);
        this.DFS();
        if (this.k != this.n - 1) {
            return false;
        }
        this.findAllIdom();
        this.preprocessDominanceRequests();
        return true;
    }

    protected void initParams(boolean inverseGraph) {
        for (int i = 0; i < this.n; ++i) {
            this.T.getSuccOf(i).clear();
            this.T.getPredOf(i).clear();
            if (inverseGraph) {
                this.succs[i] = this.g.getPredOf(i);
                this.preds[i] = this.g.getSuccOf(i);
            } else {
                this.succs[i] = this.g.getSuccOf(i);
                this.preds[i] = this.g.getPredOf(i);
            }
            this.semi[i] = -1;
            this.ancestor[i] = -1;
            this.bucket[i] = -1;
        }
    }

    protected void DFS() {
        int node = this.root;
        this.semi[node] = this.k = 0;
        this.label[node] = node;
        this.vertex[this.k] = node;
        boolean notFinished = true;
        boolean first = true;
        while (notFinished) {
            int next;
            if (first) {
                next = this.succs[node].getFirstElement();
                first = false;
            } else {
                next = this.succs[node].getNextElement();
            }
            if (next >= 0) {
                if (this.semi[next] != -1) continue;
                this.semi[next] = ++this.k;
                this.label[next] = next;
                this.vertex[this.k] = next;
                this.parent[next] = node;
                node = next;
                first = true;
                continue;
            }
            if (node == this.root) {
                notFinished = false;
                break;
            }
            node = this.parent[node];
            first = false;
        }
    }

    protected void findAllIdom() {
        int w;
        int i;
        for (i = this.n - 1; i >= 1; --i) {
            int u;
            w = this.vertex[i];
            ISet prds = this.preds[w];
            int v = prds.getFirstElement();
            while (v >= 0) {
                u = this.EVAL(v);
                if (this.semi[u] < this.semi[w]) {
                    this.semi[w] = this.semi[u];
                }
                v = prds.getNextElement();
            }
            if (this.vertex[this.semi[w]] != this.parent[w]) {
                this.addToBucket(this.vertex[this.semi[w]], w);
            } else {
                this.dom[w] = this.parent[w];
            }
            this.LINK(this.parent[w], w);
            int oldBI = this.parent[w];
            v = this.bucket[oldBI];
            while (v != -1) {
                this.bucket[oldBI] = -1;
                u = this.EVAL(v);
                this.dom[v] = this.semi[u] < this.semi[v] ? u : this.parent[w];
                oldBI = v;
                v = this.bucket[v];
            }
        }
        for (i = 1; i < this.n; ++i) {
            w = this.vertex[i];
            if (this.dom[w] != this.vertex[this.semi[w]]) {
                this.dom[w] = this.dom[this.dom[w]];
            }
            this.T.addArc(this.dom[w], w);
        }
        this.dom[this.root] = this.root;
    }

    protected void addToBucket(int buckIdx, int element) {
        if (this.bucket[buckIdx] == -1) {
            this.bucket[buckIdx] = element;
        } else {
            int old = this.bucket[buckIdx];
            this.bucket[buckIdx] = element;
            this.bucket[element] = old;
        }
    }

    protected abstract void LINK(int var1, int var2);

    protected abstract int EVAL(int var1);

    protected abstract void COMPRESS(int var1);

    public int getImmediateDominatorsOf(int x) {
        return this.dom[x];
    }

    public boolean isDomminatedBy(int x, int y) {
        return this.ancestor[x] > this.ancestor[y] && this.semi[x] < this.semi[y];
    }

    public DirectedGraph getDominatorTree() {
        return this.T;
    }

    protected void preprocessDominanceRequests() {
        int currentNode;
        for (int i = 0; i < this.n; ++i) {
            this.parent[i] = -1;
            this.succs[i] = this.T.getSuccOf(i);
        }
        int time = 0;
        this.parent[currentNode] = currentNode = this.root;
        this.ancestor[currentNode] = 0;
        boolean first = true;
        boolean finished = false;
        while (!finished) {
            int nextNode;
            if (first) {
                nextNode = this.succs[currentNode].getFirstElement();
                first = false;
            } else {
                nextNode = this.succs[currentNode].getNextElement();
            }
            if (nextNode < 0) {
                this.semi[currentNode] = ++time;
                if (currentNode == this.root) {
                    finished = true;
                    break;
                }
                first = false;
                currentNode = this.parent[currentNode];
                continue;
            }
            if (this.parent[nextNode] != -1) continue;
            this.ancestor[nextNode] = ++time;
            this.parent[nextNode] = currentNode;
            currentNode = nextNode;
            first = true;
        }
    }

    public boolean isArcDominator(int x, int y) {
        throw new UnsupportedOperationException("method not implemented yet");
    }
}

