/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.iterators;

import org.chocosolver.util.iterators.DisposableIterator;

public final class ArrayIterator<E>
extends DisposableIterator<E> {
    private E[] elements;
    private int size;
    private int cursor;

    private ArrayIterator() {
    }

    private static ArrayIterator build() {
        return new ArrayIterator();
    }

    public static synchronized <E> ArrayIterator<E> getIterator(E[] elements, int size) {
        ArrayIterator it = Holder.instance;
        if (!it.isReusable()) {
            it = ArrayIterator.build();
        }
        it.init(elements, size);
        return it;
    }

    public static synchronized <E> ArrayIterator<E> getIterator(E[] elements) {
        ArrayIterator it = Holder.instance;
        if (!it.isReusable()) {
            it = ArrayIterator.build();
        }
        it.init(elements, elements.length);
        return it;
    }

    private void init(E[] someElements, int aSize) {
        super.init();
        this.elements = someElements;
        this.size = aSize;
        this.cursor = 0;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.size;
    }

    @Override
    public E next() {
        return this.elements[this.cursor++];
    }

    @Override
    public void dispose() {
        super.dispose();
        Holder.set(this);
    }

    static /* synthetic */ ArrayIterator access$000() {
        return ArrayIterator.build();
    }

    private static final class Holder {
        private static ArrayIterator instance = ArrayIterator.access$000();

        private Holder() {
        }

        private static void set(ArrayIterator iterator) {
            instance = iterator;
        }
    }
}

