/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.iterators;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.util.iterators.DisposableIntIterator;

public class CacheIntIterator
extends DisposableIntIterator {
    boolean read = false;
    TIntArrayList values;
    int idx;
    DisposableIntIterator iterator;

    public CacheIntIterator(DisposableIntIterator iterator) {
        this.iterator = iterator;
        this.values = new TIntArrayList();
    }

    public void init(DisposableIntIterator iterator) {
        this.iterator = iterator;
        this.values.clear();
        this.read = false;
        this.init();
    }

    @Override
    public void init() {
        super.init();
        this.idx = 0;
    }

    @Override
    public void dispose() {
        this.iterator.dispose();
        this.read = true;
    }

    @Override
    public boolean hasNext() {
        return this.read ? this.idx < this.values.size() : this.iterator.hasNext();
    }

    @Override
    public int next() {
        if (this.read) {
            return this.values.get(this.idx++);
        }
        int v = this.iterator.next();
        this.values.add(v);
        return v;
    }
}

