/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects;

public class SparseSet {
    int[] sparse = new int[16];
    int[] dense = new int[16];
    int members;

    public boolean contains(int k) {
        if (k < this.sparse.length) {
            int a = this.sparse[k];
            return a < this.members && this.dense[a] == k;
        }
        return false;
    }

    public void add(int k) {
        this.ensureCapacity(k + 1);
        int a = this.sparse[k];
        if (a >= this.members || this.dense[a] != k) {
            this.sparse[k] = this.members;
            this.dense[this.members] = k;
            ++this.members;
        }
    }

    private void ensureCapacity(int k) {
        if (k > this.sparse.length - 1) {
            int[] tmp = this.sparse;
            int nsize = Math.max(k + 1, tmp.length * 3 / 2 + 1);
            this.sparse = new int[nsize];
            System.arraycopy(tmp, 0, this.sparse, 0, tmp.length);
            tmp = this.dense;
            this.dense = new int[nsize];
            System.arraycopy(tmp, 0, this.dense, 0, tmp.length);
        }
    }

    public void clear() {
        this.members = 0;
    }
}

