/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects;

import java.util.ArrayList;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.memory.structure.IndexedObject;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.util.iterators.DisposableIntIterator;

public class StoredIndexedBipartiteSet {
    protected int[] list;
    protected int[] position;
    protected IndexedObject[] idxToObjects;
    protected IStateInt last;
    protected BipartiteSetIterator _cachedIterator;

    private StoredIndexedBipartiteSet() {
    }

    public StoredIndexedBipartiteSet(IEnvironment environment, int[] values) {
        this.buildList(environment, values);
    }

    public StoredIndexedBipartiteSet(IEnvironment environment, IndexedObject[] values) {
        int i;
        int[] intvalues = new int[values.length];
        for (i = 0; i < intvalues.length; ++i) {
            intvalues[i] = values[i].getObjectIdx();
        }
        this.buildList(environment, intvalues);
        this.idxToObjects = new IndexedObject[this.position.length];
        for (i = 0; i < intvalues.length; ++i) {
            this.idxToObjects[values[i].getObjectIdx()] = values[i];
        }
    }

    public StoredIndexedBipartiteSet(IEnvironment environment, ArrayList<IndexedObject> values) {
        int i;
        int[] intvalues = new int[values.size()];
        for (i = 0; i < intvalues.length; ++i) {
            intvalues[i] = values.get(i).getObjectIdx();
        }
        this.buildList(environment, intvalues);
        this.idxToObjects = new IndexedObject[this.position.length];
        for (i = 0; i < intvalues.length; ++i) {
            this.idxToObjects[values.get((int)i).getObjectIdx()] = values.get(i);
        }
    }

    public void buildList(IEnvironment environment, int[] values) {
        int i;
        this.list = values;
        int maxElt = 0;
        for (i = 0; i < values.length; ++i) {
            if (values[i] <= maxElt) continue;
            maxElt = values[i];
        }
        this.position = new int[maxElt + 1];
        for (i = 0; i < values.length; ++i) {
            this.position[values[i]] = i;
        }
        this.last = environment.makeInt(this.list.length - 1);
    }

    public StoredIndexedBipartiteSet(IEnvironment environment, int nbValues) {
        int[] values = new int[nbValues];
        for (int i = 0; i < nbValues; ++i) {
            values[i] = i;
        }
        this.buildList(environment, values);
    }

    public final void increaseSize(int gap) {
        int l = this.list.length;
        int[] newList = new int[l + gap];
        for (int i = 0; i < l + gap; ++i) {
            newList[i] = i;
        }
        int maxElt = 0;
        for (int i = 0; i < newList.length; ++i) {
            if (newList[i] <= maxElt) continue;
            maxElt = newList[i];
        }
        int[] newPosition = new int[maxElt + 1];
        for (int i = 0; i < newList.length; ++i) {
            newPosition[newList[i]] = i;
        }
        int end = this.last.get() + 1;
        int[] removed = new int[this.list.length - end];
        System.arraycopy(this.list, end, removed, 0, this.list.length - end);
        this.list = newList;
        this.position = newPosition;
        IEnvironment env = this.last.getEnvironment();
        this.last = null;
        this.last = env.makeInt(this.list.length - 1);
        for (int i = 0; i < removed.length; ++i) {
            this.remove(removed[i]);
        }
    }

    public final int size() {
        return this.last.get() + 1;
    }

    public final boolean isEmpty() {
        return this.last.get() == -1;
    }

    public final void add(int i) {
        throw new UnsupportedOperationException("adding element is not permitted in this structure (the list is only meant to decrease during search)");
    }

    public final void clear() {
        this.last.set(-1);
    }

    public final void removeLast() {
        this.remove(this.list[this.last.get()]);
    }

    public void remove(int object) {
        if (this.contains(object)) {
            int idxToRem = this.position[object];
            if (idxToRem == this.last.get()) {
                this.last.add(-1);
            } else {
                int temp = this.list[this.last.get()];
                this.list[this.last.get()] = object;
                this.list[idxToRem] = temp;
                this.position[object] = this.last.get();
                this.position[temp] = idxToRem;
                this.last.add(-1);
            }
        }
    }

    public final void remove(IndexedObject object) {
        this.remove(object.getObjectIdx());
    }

    public boolean contains(int object) {
        return this.position[object] <= this.last.get();
    }

    public final boolean contains(IndexedObject object) {
        return this.contains(object.getObjectIdx());
    }

    public final int get(int index) {
        return this.list[index];
    }

    public final IndexedObject getObject(int index) {
        return this.idxToObjects[this.list[index]];
    }

    public final int set(int index, int val) {
        throw new SolverException("setting an element is not permitted on this structure");
    }

    public final DisposableIntIterator getIterator() {
        if (this._cachedIterator == null || !this._cachedIterator.isReusable()) {
            this._cachedIterator = new BipartiteSetIterator();
        }
        this._cachedIterator.init(this.list, this.position, this.last, this.idxToObjects);
        return this._cachedIterator;
    }

    public final String pretty() {
        StringBuilder s = new StringBuilder("[");
        for (int i = 0; i <= this.last.get(); ++i) {
            s.append(this.list[i]).append(i == this.last.get() ? "" : ",");
        }
        return s.append(']').toString();
    }

    public final int findIndexOfInt(int a) {
        return this.list.length - this.position[a];
    }

    public final int[] _getStructure() {
        return this.list;
    }

    public StoredIndexedBipartiteSet duplicate(Solver solver) {
        StoredIndexedBipartiteSet copy = new StoredIndexedBipartiteSet();
        copy.list = (int[])this.list.clone();
        copy.position = (int[])this.position.clone();
        copy.last = solver.getEnvironment().makeInt(this.list.length - 1);
        if (this.idxToObjects != null) {
            copy.idxToObjects = new IndexedObject[this.position.length];
            for (int i = 0; i < this.idxToObjects.length; ++i) {
                try {
                    copy.idxToObjects[i] = this.idxToObjects[i].clone();
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                    throw new SolverException("Clone not supported");
                }
            }
        }
        return copy;
    }

    protected static class BipartiteSetIterator
    extends DisposableIntIterator {
        private int[] list;
        private int[] position;
        private IndexedObject[] idxToObjects;
        private IStateInt last;
        private int nlast;
        private int idx;

        protected BipartiteSetIterator() {
        }

        public void init(int[] aList, int[] aPosition, IStateInt aLast, IndexedObject[] anIdxToObjects) {
            super.init();
            this.idx = 0;
            this.list = aList;
            this.position = aPosition;
            this.idxToObjects = anIdxToObjects;
            this.last = aLast;
            this.nlast = this.last.get();
        }

        @Override
        public boolean hasNext() {
            return this.idx <= this.nlast;
        }

        @Override
        public int next() {
            return this.list[this.idx++];
        }

        public IndexedObject nextObject() {
            return this.idxToObjects[this.list[this.idx++]];
        }

        @Override
        public void remove() {
            --this.idx;
            int idxToRem = this.idx;
            if (idxToRem == this.nlast) {
                this.last.add(-1);
                --this.nlast;
            } else {
                int temp = this.list[this.nlast];
                this.list[this.nlast] = this.list[idxToRem];
                this.list[idxToRem] = temp;
                this.position[this.list[this.nlast]] = this.last.get();
                this.position[temp] = idxToRem;
                this.last.add(-1);
                --this.nlast;
            }
        }
    }
}

