/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects;

import java.io.Serializable;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;

public class StoredSparseSet
implements Serializable {
    int[] sparse;
    int[] dense;
    IStateInt members;

    public StoredSparseSet(IEnvironment environment) {
        this.members = environment.makeInt(0);
        this.sparse = new int[16];
        this.dense = new int[16];
    }

    public boolean contains(int k) {
        if (k < this.sparse.length) {
            int a = this.sparse[k];
            return a < this.members.get() && this.dense[a] == k;
        }
        return false;
    }

    public void add(int k) {
        this.ensureCapacity(k + 1);
        int a = this.sparse[k];
        int b = this.members.get();
        if (a >= b || this.dense[a] != k) {
            this.sparse[k] = b;
            this.dense[b] = k;
            this.members.set(b + 1);
        }
    }

    private void ensureCapacity(int k) {
        if (k > this.sparse.length) {
            int[] tmp = this.sparse;
            int nsize = Math.max(k + 1, tmp.length * 3 / 2 + 1);
            this.sparse = new int[nsize];
            this.sparse = new int[nsize];
            System.arraycopy(tmp, 0, this.sparse, 0, tmp.length);
            tmp = this.dense;
            this.dense = new int[nsize];
            System.arraycopy(tmp, 0, this.dense, 0, tmp.length);
        }
    }
}

