/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.graphs;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class DirectedGraph
implements IGraph {
    ISet[] successors;
    ISet[] predecessors;
    ISet nodes;
    int n;
    SetType type;

    public DirectedGraph(int n, SetType type, boolean allNodes) {
        this.type = type;
        this.n = n;
        this.predecessors = new ISet[n];
        this.successors = new ISet[n];
        for (int i = 0; i < n; ++i) {
            this.predecessors[i] = SetFactory.makeSet(type, n);
            this.successors[i] = SetFactory.makeSet(type, n);
        }
        this.nodes = allNodes ? SetFactory.makeFullSet(n) : SetFactory.makeBitSet(n);
    }

    public DirectedGraph(Solver solver, int n, SetType type, boolean allNodes) {
        this.n = n;
        this.type = type;
        this.predecessors = new ISet[n];
        this.successors = new ISet[n];
        for (int i = 0; i < n; ++i) {
            this.predecessors[i] = SetFactory.makeStoredSet(type, n, solver);
            this.successors[i] = SetFactory.makeStoredSet(type, n, solver);
        }
        this.nodes = allNodes ? SetFactory.makeFullSet(n) : SetFactory.makeStoredSet(SetType.BITSET, n, solver);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes : \n").append(this.nodes).append("\n");
        sb.append("successors : \n");
        int i = this.nodes.getFirstElement();
        while (i >= 0) {
            sb.append(i).append(" -> {");
            int j = this.successors[i].getFirstElement();
            while (j >= 0) {
                sb.append(j).append(" ");
                j = this.successors[i].getNextElement();
            }
            sb.append("}\n");
            i = this.nodes.getNextElement();
        }
        return sb.toString();
    }

    @Override
    public int getNbMaxNodes() {
        return this.n;
    }

    @Override
    public ISet getNodes() {
        return this.nodes;
    }

    @Override
    public SetType getType() {
        return this.type;
    }

    @Override
    public boolean addNode(int x) {
        return !this.nodes.contain(x) && this.nodes.add(x);
    }

    @Override
    public boolean removeNode(int x) {
        if (this.nodes.remove(x)) {
            int j = this.successors[x].getFirstElement();
            while (j >= 0) {
                this.predecessors[j].remove(x);
                j = this.successors[x].getNextElement();
            }
            this.successors[x].clear();
            j = this.predecessors[x].getFirstElement();
            while (j >= 0) {
                this.successors[j].remove(x);
                j = this.predecessors[x].getNextElement();
            }
            this.predecessors[x].clear();
            return true;
        }
        assert (this.predecessors[x].getSize() == 0) : "incoherent directed graph";
        assert (this.successors[x].getSize() == 0) : "incoherent directed graph";
        return false;
    }

    public boolean removeArc(int from, int to) {
        if (this.successors[from].contain(to)) {
            assert (this.predecessors[to].contain(from)) : "incoherent directed graph";
            this.successors[from].remove(to);
            this.predecessors[to].remove(from);
            return true;
        }
        return false;
    }

    public boolean arcExists(int from, int to) {
        if (this.successors[from].contain(to)) {
            assert (this.predecessors[to].contain(from)) : "incoherent directed graph";
            return true;
        }
        return false;
    }

    @Override
    public boolean isArcOrEdge(int from, int to) {
        return this.arcExists(from, to);
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    public boolean addArc(int from, int to) {
        this.addNode(from);
        this.addNode(to);
        if (!this.successors[from].contain(to)) {
            assert (!this.predecessors[to].contain(from)) : "incoherent directed graph";
            this.successors[from].add(to);
            this.predecessors[to].add(from);
            return true;
        }
        return false;
    }

    public ISet getSuccOf(int x) {
        return this.successors[x];
    }

    @Override
    public ISet getSuccOrNeighOf(int x) {
        return this.successors[x];
    }

    public ISet getPredOf(int x) {
        return this.predecessors[x];
    }

    @Override
    public ISet getPredOrNeighOf(int x) {
        return this.predecessors[x];
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        throw new UnsupportedOperationException("Cannot duplicate DirectedGraph yet");
    }
}

