/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.graphs;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.variables.IntVar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultivaluedDecisionDiagram
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultivaluedDecisionDiagram.class);
    public static final int TERMINAL = -1;
    public static final int EMPTY = 0;
    private final int nbLayers;
    private final int[] sizes;
    private final int[] offsets;
    private int[] mdd;
    private int nextFreeCell;
    private final boolean compactOnce;
    private final boolean sortTuples;
    private TIntIntHashMap _nodesToRemove;
    private ArrayList<int[]>[][] _identicalNodes;
    private TIntArrayList[][] _nodeId;
    private int _removedCells;
    private int[] _pos;

    private static int[][] flattenDomain(IntVar[] VARIABLES) {
        int[][] FLATDOM = new int[VARIABLES.length][];
        for (int i = 0; i < VARIABLES.length; ++i) {
            int lb = VARIABLES[i].getLB();
            int ub = VARIABLES[i].getUB();
            int size = ub - lb + 1;
            FLATDOM[i] = new int[size];
            for (int j = 0; j < size; ++j) {
                FLATDOM[i][j] = j + lb;
            }
        }
        return FLATDOM;
    }

    public MultivaluedDecisionDiagram(IntVar[] VARIABLES, Tuples TUPLES) {
        this(MultivaluedDecisionDiagram.flattenDomain(VARIABLES), TUPLES);
    }

    public MultivaluedDecisionDiagram(IntVar[] VARIABLES, Tuples TUPLES, boolean compactOnce, boolean sortTuple) {
        this(MultivaluedDecisionDiagram.flattenDomain(VARIABLES), TUPLES, compactOnce, sortTuple);
    }

    public MultivaluedDecisionDiagram(int[][] FLATDOM, Tuples TUPLES) {
        this(FLATDOM, TUPLES, true, false);
    }

    public MultivaluedDecisionDiagram(int[][] FLATDOM, Tuples TUPLES, boolean compactOnce, boolean sortTuple) {
        this.nbLayers = FLATDOM.length;
        this.offsets = new int[this.nbLayers];
        this.sizes = new int[this.nbLayers];
        this.compactOnce = compactOnce;
        this.sortTuples = sortTuple;
        int maxDom = 0;
        for (int i = 0; i < this.nbLayers; ++i) {
            this.offsets[i] = FLATDOM[i][0];
            this.sizes[i] = FLATDOM[i][FLATDOM[i].length - 1] - FLATDOM[i][0] + 1;
            if (maxDom >= this.sizes[i]) continue;
            maxDom = this.sizes[i];
        }
        this.mdd = new int[this.nbLayers * maxDom];
        this.init(TUPLES);
    }

    private MultivaluedDecisionDiagram(MultivaluedDecisionDiagram MDD) {
        this.nbLayers = MDD.nbLayers;
        this.offsets = (int[])MDD.offsets.clone();
        this.sizes = (int[])MDD.sizes.clone();
        this.compactOnce = MDD.compactOnce;
        this.sortTuples = MDD.sortTuples;
        this.mdd = (int[])MDD.mdd.clone();
        this.nextFreeCell = this.sizes[0];
        this._nodesToRemove = new TIntIntHashMap(16, 0.5f, -1, -1);
        this._identicalNodes = new ArrayList[this.nbLayers][];
        this._nodeId = new TIntArrayList[this.nbLayers][];
        this._removedCells = MDD._removedCells;
        this._pos = (int[])MDD._pos.clone();
    }

    private void init(Tuples TUPLES) {
        this.nextFreeCell = this.sizes[0];
        this._pos = new int[this.nbLayers];
        this._nodesToRemove = new TIntIntHashMap(16, 0.5f, -1, -1);
        this._identicalNodes = new ArrayList[this.nbLayers][];
        this._nodeId = new TIntArrayList[this.nbLayers][];
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Add {} tuples", (Object)TUPLES.nbTuples());
        }
        if (TUPLES.nbTuples() > 0) {
            this.addTuples(TUPLES);
            if (this.compactOnce) {
                this.compact();
            }
        }
    }

    public void addTuples(Tuples TUPLES) {
        if (this.sortTuples) {
            TUPLES.sort();
        }
        for (int t = 0; t < TUPLES.nbTuples(); ++t) {
            this.addTuple(TUPLES.get(t));
        }
    }

    public void addTuple(int[] TUPLE) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Add: {}", (Object)Arrays.toString(TUPLE));
        }
        for (int i = 0; i < this.nbLayers; ++i) {
            this._pos[i] = TUPLE[i] - this.offsets[i];
        }
        int p = 0;
        for (int i = 0; i < this.nbLayers; ++i) {
            this.ensureCapacity((p += this._pos[i]) + this.sizes[i]);
            if (this.mdd[p] == 0) {
                if (i + 1 == this.nbLayers) {
                    this.mdd[p] = -1;
                    continue;
                }
                p = this.mdd[p] = this.nextFreeCell;
                this.nextFreeCell += this.sizes[i + 1];
                continue;
            }
            p = this.mdd[p];
        }
        if (!this.compactOnce) {
            this.compact();
        }
    }

    private void ensureCapacity(int nsize) {
        if (nsize > this.mdd.length) {
            int[] _mdd = this.mdd;
            this.mdd = new int[nsize * 3 / 2 + 1];
            System.arraycopy(_mdd, 0, this.mdd, 0, _mdd.length);
        }
    }

    private void compact() {
        this._nodesToRemove.clear();
        for (int i = 0; i < this.nbLayers; ++i) {
            this._identicalNodes[i] = new ArrayList[this.sizes[i]];
            this._nodeId[i] = new TIntArrayList[this.sizes[i]];
        }
        this._removedCells = 0;
        this.detectIsomorphism(0, 0);
        this.deleteIsomorphism();
    }

    private int detectIsomorphism(int node, int layer) {
        int[] nodeChild = new int[this.sizes[layer]];
        int nbChild = -1;
        block4: for (int i = 0; i < this.sizes[layer]; ++i) {
            switch (this.mdd[node + i]) {
                case 0: {
                    continue block4;
                }
                case -1: {
                    ++nbChild;
                    nodeChild[i] = -1;
                    continue block4;
                }
                default: {
                    ++nbChild;
                    this.mdd[node + i] = nodeChild[i] = this.detectIsomorphism(this.mdd[node + i], layer + 1);
                }
            }
        }
        boolean known = false;
        if (this._identicalNodes[layer][nbChild] == null) {
            this._identicalNodes[layer][nbChild] = new ArrayList();
            this._nodeId[layer][nbChild] = new TIntArrayList();
        } else {
            for (int j = this._identicalNodes[layer][nbChild].size() - 1; j >= 0; --j) {
                int[] currentNode = this._identicalNodes[layer][nbChild].get(j);
                boolean found = this._nodeId[layer][nbChild].get(j) != node;
                known |= !found;
                for (int i = currentNode.length - 1; i >= 0 && found; --i) {
                    if (currentNode[i] == nodeChild[i]) continue;
                    found = false;
                }
                if (!found) continue;
                int insert = this._nodesToRemove.put(node, this.sizes[layer]);
                if (insert == -1) {
                    this._removedCells += this.sizes[layer];
                }
                return this._nodeId[layer][nbChild].get(j);
            }
        }
        if (!known) {
            this._nodeId[layer][nbChild].add(node);
            this._identicalNodes[layer][nbChild].add(nodeChild);
        }
        return node;
    }

    private void deleteIsomorphism() {
        int[] compacted = new int[this.nextFreeCell - this._removedCells];
        int[] nodes = new int[this._nodesToRemove.size() + 1];
        int[] gains = new int[this._nodesToRemove.size() + 1];
        int idx = 1;
        if (this._nodesToRemove.isEmpty()) {
            System.arraycopy(this.mdd, 0, compacted, 0, this.nextFreeCell);
            this.mdd = compacted;
        } else {
            int from = 0;
            int gain = 0;
            int[] keys = this._nodesToRemove.keys();
            Arrays.sort(keys);
            int[] nArray = keys;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int k;
                nodes[idx] = k = nArray[i];
                int to = nodes[idx] - nodes[idx - 1] - gain;
                System.arraycopy(this.mdd, nodes[idx - 1] + gain, compacted, from, to);
                from += to;
                gain = this._nodesToRemove.get(k);
                gains[idx] = gains[idx - 1] + gain;
                ++idx;
            }
            System.arraycopy(this.mdd, nodes[idx - 1] + gain, compacted, from, compacted.length - from);
            for (int i = 0; i < compacted.length; ++i) {
                if (compacted[i] <= 0) continue;
                int n2 = i;
                compacted[n2] = compacted[n2] - gains[this.searchClosest(nodes, compacted[i])];
            }
            this.mdd = compacted;
            this.nextFreeCell -= this._removedCells;
        }
    }

    protected int searchClosest(int[] a, int key) {
        int low = 0;
        int high = a.length - 1;
        int mid = low + high >> 1;
        while (low + 1 < high) {
            if (a[mid] > key) {
                high = mid;
            } else {
                low = mid;
            }
            mid = low + high >> 1;
        }
        if (a[high] <= key) {
            return high;
        }
        return low;
    }

    public int[] getDiagram() {
        return this.mdd;
    }

    public int getNodeSize(int layer) {
        return this.sizes[layer];
    }

    public int getOffset(int layer) {
        return this.offsets[layer];
    }

    public int getEdge(int k) {
        return this.mdd[k];
    }

    public boolean exists(int ... PATH) {
        if (PATH.length == this.nbLayers) {
            int p = 0;
            for (int i = 0; i < this.nbLayers; ++i) {
                if ((p += PATH[i] - this.offsets[i]) >= this.mdd.length || this.mdd[p] == 0) {
                    return false;
                }
                if (i + 1 == this.nbLayers) {
                    return this.mdd[p] == -1;
                }
                p = this.mdd[p];
            }
        }
        return false;
    }

    public MultivaluedDecisionDiagram duplicate() {
        return new MultivaluedDecisionDiagram(this);
    }
}

