/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.graphs;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class UndirectedGraph
implements IGraph {
    ISet[] neighbors;
    ISet nodes;
    int n;
    SetType type;

    public UndirectedGraph(Solver solver, int n, SetType type, boolean allNodes) {
        this.type = type;
        this.n = n;
        this.neighbors = new ISet[n];
        for (int i = 0; i < n; ++i) {
            this.neighbors[i] = SetFactory.makeStoredSet(type, n, solver);
        }
        this.nodes = allNodes ? SetFactory.makeFullSet(n) : SetFactory.makeStoredSet(SetType.BITSET, n, solver);
    }

    public UndirectedGraph(int n, SetType type, boolean allNodes) {
        this.type = type;
        this.n = n;
        this.neighbors = new ISet[n];
        for (int i = 0; i < n; ++i) {
            this.neighbors[i] = SetFactory.makeSet(type, n);
        }
        this.nodes = allNodes ? SetFactory.makeFullSet(n) : SetFactory.makeBitSet(n);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes : \n").append(this.nodes).append("\n");
        sb.append("neighbors : \n");
        int i = this.nodes.getFirstElement();
        while (i >= 0) {
            sb.append(i).append(" -> {");
            int j = this.neighbors[i].getFirstElement();
            while (j >= 0) {
                sb.append(j).append(" ");
                j = this.neighbors[i].getNextElement();
            }
            sb.append("}\n");
            i = this.nodes.getNextElement();
        }
        return sb.toString();
    }

    @Override
    public int getNbMaxNodes() {
        return this.n;
    }

    @Override
    public ISet getNodes() {
        return this.nodes;
    }

    @Override
    public SetType getType() {
        return this.type;
    }

    @Override
    public boolean addNode(int x) {
        return this.nodes.add(x);
    }

    @Override
    public boolean removeNode(int x) {
        if (this.nodes.remove(x)) {
            ISet nei = this.getNeighOf(x);
            int j = nei.getFirstElement();
            while (j >= 0) {
                this.neighbors[j].remove(x);
                j = nei.getNextElement();
            }
            this.neighbors[x].clear();
            return true;
        }
        return false;
    }

    public boolean addEdge(int x, int y) {
        if (x == y && !this.neighbors[x].contain(y)) {
            this.neighbors[x].add(y);
            return true;
        }
        if (!this.neighbors[x].contain(y)) {
            assert (!this.neighbors[y].contain(x)) : "asymmetric adjacency matrix in an undirected graph";
            this.neighbors[x].add(y);
            this.neighbors[y].add(x);
            return true;
        }
        return false;
    }

    public boolean edgeExists(int x, int y) {
        if (this.neighbors[x].contain(y)) {
            assert (this.neighbors[y].contain(x)) : "asymmetric adjacency matrix in an undirected graph";
            return true;
        }
        return false;
    }

    @Override
    public boolean isArcOrEdge(int x, int y) {
        return this.edgeExists(x, y);
    }

    public boolean removeEdge(int x, int y) {
        if (x == y && this.neighbors[x].contain(y)) {
            this.neighbors[y].remove(x);
            return true;
        }
        if (this.neighbors[x].contain(y)) {
            assert (this.neighbors[y].contain(x)) : "asymmetric adjacency matrix in an undirected graph";
            this.neighbors[x].remove(y);
            this.neighbors[y].remove(x);
            return true;
        }
        return false;
    }

    public ISet getNeighOf(int x) {
        return this.neighbors[x];
    }

    @Override
    public ISet getPredOrNeighOf(int x) {
        return this.neighbors[x];
    }

    @Override
    public ISet getSuccOrNeighOf(int x) {
        return this.neighbors[x];
    }

    @Override
    public boolean isDirected() {
        return false;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        throw new UnsupportedOperationException("Cannot duplicate DirectedGraph yet");
    }
}

