/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.queues;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.chocosolver.util.objects.queues.IHeap;

public class BinaryTreeHeap
implements IHeap {
    final int size;
    Node[] nodeFromElement;
    Node root;
    Deque<Node> freeNodes = new ArrayDeque<Node>();
    boolean mergeSide = true;
    private ArrayList<Node> sortedNodes;

    public BinaryTreeHeap(int[] elements, int[] values) {
        this.size = elements.length;
        this.nodeFromElement = new Node[this.size];
        this.nodeFromElement[elements[0]] = this.root = new Node(elements[0], values[0]);
        for (int i = 1; i < this.size; ++i) {
            Node n = new Node(elements[i], values[i]);
            this.root.put(n);
            this.nodeFromElement[elements[i]] = n;
        }
    }

    public BinaryTreeHeap(int size) {
        this.size = size;
        this.nodeFromElement = new Node[this.size];
        for (int i = 0; i < size; ++i) {
            this.freeNodes.addFirst(new Node(-1, -1));
        }
        this.root = null;
    }

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    @Override
    public int size() {
        return this.size - this.freeNodes.size();
    }

    public int getLastRemValue() {
        return this.freeNodes.getLast().value;
    }

    @Override
    public void insert(int value, int element) {
        Node n = this.freeNodes.removeFirst();
        n.clear();
        n.setNode(element, value);
        this.nodeFromElement[element] = n;
        if (this.root == null) {
            this.root = n;
        } else {
            this.root.put(n);
        }
        assert (this.flattenBinTree()) : n;
    }

    @Override
    public int remove(int element) {
        Node n = this.nodeFromElement[element];
        Node potRoot = n.remove(this.mergeSide);
        if (n == this.root) {
            this.root = potRoot != null ? potRoot : null;
        }
        this.freeNode(n);
        boolean bl = this.mergeSide = !this.mergeSide;
        assert (this.flattenBinTree()) : n;
        return n.element;
    }

    @Override
    public void update(int newValue, int element) {
        this.insert(newValue, this.remove(element));
    }

    @Override
    public int removemin() {
        return this.remove(this.root.minChildren().element);
    }

    private void freeNode(Node n) {
        this.nodeFromElement[n.element] = null;
        this.freeNodes.addLast(n);
    }

    private boolean flattenBinTree() {
        this.sortedNodes = new ArrayList();
        if (this.root != null) {
            this.openNode(this.root);
        }
        return this.sortedNodes.size() == this.size() && this.checkResult();
    }

    private void openNode(Node next) {
        if (next.left == null && next.right == null) {
            this.sortedNodes.add(next);
        } else {
            if (next.left != null) {
                this.openNode(next.left);
            }
            this.sortedNodes.add(next);
            if (next.right != null) {
                this.openNode(next.right);
            }
        }
    }

    private boolean checkResult() {
        for (int i = 0; i < this.sortedNodes.size() - 1; ++i) {
            if (this.sortedNodes.get((int)i).value <= this.sortedNodes.get((int)(i + 1)).value) continue;
            System.out.println(this.toString());
            return false;
        }
        return true;
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.sortedNodes.size(); ++i) {
            s = s + this.sortedNodes.get(i) + ",";
        }
        return s;
    }

    private class Node {
        int element;
        int value;
        Node father;
        Node left;
        Node right;

        Node(int element, int value) {
            this.element = element;
            this.value = value;
            this.father = null;
            this.right = null;
            this.left = null;
        }

        public void clear() {
            this.element = -1;
            this.value = -1;
            this.left = null;
            this.right = null;
            this.father = null;
        }

        public void setNode(int element, int value) {
            this.element = element;
            this.value = value;
        }

        public void put(Node next) {
            Node cur = this;
            while (cur != null) {
                if (next.value < cur.value) {
                    if (cur.left != null) {
                        cur = cur.left;
                        continue;
                    }
                    cur.left = next;
                    cur.left.father = cur;
                    cur = null;
                    continue;
                }
                if (cur.right != null) {
                    cur = cur.right;
                    continue;
                }
                cur.right = next;
                cur.right.father = cur;
                cur = null;
            }
        }

        public Node remove(boolean side) {
            return side ? this.removeLeft() : this.removeRight();
        }

        private Node removeLeft() {
            if (this.left != null) {
                return this.mergeLeftUp();
            }
            if (this.right != null) {
                return this.mergeRightUp();
            }
            if (this.father != null) {
                if (this.father.left == this) {
                    this.father.left = null;
                } else {
                    this.father.right = null;
                }
                this.father = null;
            }
            return null;
        }

        private Node removeRight() {
            if (this.right != null) {
                return this.mergeRightUp();
            }
            if (this.left != null) {
                return this.mergeLeftUp();
            }
            if (this.father != null) {
                if (this.father.left == this) {
                    this.father.left = null;
                } else {
                    this.father.right = null;
                }
                this.father = null;
            }
            return null;
        }

        private Node mergeLeftUp() {
            Node potRoot = null;
            this.left.father = this.father;
            if (this.father != null) {
                if (this.father.left == this) {
                    this.father.left = this.left;
                } else {
                    this.father.right = this.left;
                }
            } else {
                potRoot = this.left;
            }
            if (this.right != null) {
                Node maxRightLeft = this.left.maxChildren();
                maxRightLeft.right = this.right;
                this.right.father = maxRightLeft;
            }
            return potRoot;
        }

        private Node mergeRightUp() {
            Node potRoot = null;
            this.right.father = this.father;
            if (this.father != null) {
                if (this.father.left == this) {
                    this.father.left = this.right;
                } else {
                    this.father.right = this.right;
                }
            } else {
                potRoot = this.right;
            }
            if (this.left != null) {
                Node minLeftRight = this.right.minChildren();
                minLeftRight.left = this.left;
                this.left.father = minLeftRight;
            }
            return potRoot;
        }

        public Node maxChildren() {
            Node cur = this;
            Node rcur = this.right;
            while (rcur != null) {
                cur = rcur;
                rcur = rcur.right;
            }
            return cur;
        }

        public Node minChildren() {
            Node cur = this;
            Node lcur = this.left;
            while (lcur != null) {
                cur = lcur;
                lcur = lcur.left;
            }
            return cur;
        }

        public String toString() {
            return "(" + this.element + "," + this.value + ")";
        }

        public String completeString() {
            if (this.father != null) {
                if (this.left != null) {
                    if (this.right != null) {
                        return this + "--F:" + this.father + ";G:" + this.left + ";D:" + this.right;
                    }
                    return this + "--F:" + this.father + ";G:" + this.left + ";D:-";
                }
                if (this.right != null) {
                    return this + "--F:" + this.father + ";G:-" + ";D:" + this.right;
                }
                return this + "--F:" + this.father + ";G:-" + ";D:-";
            }
            if (this.left != null) {
                if (this.right != null) {
                    return this + "--F:-" + ";G:" + this.left + ";D:" + this.right;
                }
                return this + "--F:-" + ";G:" + this.left + ";D:-";
            }
            if (this.right != null) {
                return this + "--F:-" + ";G:-" + ";D:" + this.right;
            }
            return this + "--F:-" + ";G:-" + ";D:-";
        }
    }

    static enum Type {
        INSERT,
        REMOVE,
        CONSTRUCTOR;

    }
}

