/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.queues;

import java.io.Serializable;
import org.chocosolver.util.objects.queues.AQueue;

public class CircularQueue<E>
implements AQueue<E>,
Serializable {
    E[] elementData;
    int head = 0;
    int tail = 0;
    int size = 0;
    int capacity;

    private static int closestGreater2n(int size) {
        if (size == 0) {
            return 2;
        }
        int _size = Integer.highestOneBit(size) << 1;
        assert (_size >= size);
        return _size;
    }

    public CircularQueue(int size) {
        size = CircularQueue.closestGreater2n(size);
        this.elementData = new Object[size];
        this.capacity = size;
    }

    private int convert(int base, int delta) {
        return base + delta & this.capacity - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.tail = 0;
        this.head = 0;
    }

    @Override
    public E get(int index) {
        return this.elementData[this.convert(index, this.head)];
    }

    @Override
    public boolean addFirst(E e) {
        this.head = this.convert(this.head, -1);
        this.elementData[this.head] = e;
        ++this.size;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
        return true;
    }

    @Override
    public boolean addLast(E e) {
        this.elementData[this.tail] = e;
        ++this.size;
        this.tail = this.convert(this.tail, 1);
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
        return true;
    }

    @Override
    public int indexOf(E elem) {
        assert (elem != null);
        for (int i = 0; i < this.size; ++i) {
            if (!elem.equals(this.elementData[this.convert(this.head, i)])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public E pollFirst() {
        int pos = this.convert(this.head, 0);
        E tmp = this.elementData[pos];
        if (pos == this.head) {
            this.head = this.convert(this.head, 1);
        }
        --this.size;
        return tmp;
    }

    @Override
    public E pollLast() {
        int pos = this.convert(this.tail, -1);
        E tmp = this.elementData[pos];
        this.tail = pos;
        --this.size;
        return tmp;
    }

    public E remove() {
        int pos = this.convert(this.head, 0);
        E tmp = this.elementData[pos];
        if (pos == this.head) {
            this.head = this.convert(this.head, 1);
        }
        --this.size;
        return tmp;
    }

    @Override
    public E remove(int index) {
        int pos = this.convert(this.head, index);
        E tmp = this.elementData[pos];
        if (pos - this.head == 0) {
            this.head = this.convert(this.head, 1);
        } else if (pos - this.tail == 0) {
            this.tail = this.convert(this.tail - 1, this.capacity);
        } else if (pos > this.head && pos > this.tail) {
            System.arraycopy(this.elementData, this.head, this.elementData, this.head + 1, pos - this.head);
            this.head = this.convert(this.head, 1);
        } else {
            System.arraycopy(this.elementData, pos + 1, this.elementData, pos, this.tail - pos - 1);
            this.tail = this.convert(this.tail - 1, this.capacity);
        }
        --this.size;
        return tmp;
    }

    @Override
    public boolean remove(E e) {
        int i = this.indexOf(e);
        if (i > -1) {
            this.remove(i);
            return true;
        }
        return false;
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int p = this.head;
        int n = this.capacity;
        int r = n - p;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Sorry, deque too big");
        }
        Object[] a = new Object[newCapacity];
        System.arraycopy(this.elementData, p, a, 0, r);
        System.arraycopy(this.elementData, 0, a, r, p);
        this.elementData = a;
        this.head = 0;
        this.tail = n;
        this.capacity = newCapacity;
    }
}

