/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.queues;

public class DoubleMinHeap {
    private static final boolean PRINT = false;
    private double[] keys;
    private int[] elts;
    private int[] posOf;
    private int size;

    public DoubleMinHeap(int max) {
        this.keys = new double[max + 1];
        this.elts = new int[max + 1];
        this.posOf = new int[max + 1];
        this.size = 0;
        this.keys[0] = -2.147483648E9;
        this.elts[0] = Integer.MIN_VALUE;
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size - 1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private int leftchild(int pos) {
        return pos << 1;
    }

    private int rightchild(int pos) {
        return pos << 2;
    }

    private int parent(int pos) {
        return pos >> 1;
    }

    private boolean isleaf(int pos) {
        return pos > this.size >> 1 && pos <= this.size;
    }

    private void swap(int pos1, int pos2) {
        double dtmp = this.keys[pos1];
        this.keys[pos1] = this.keys[pos2];
        this.keys[pos2] = dtmp;
        this.posOf[this.elts[pos1]] = pos2;
        this.posOf[this.elts[pos2]] = pos1;
        int tmp = this.elts[pos1];
        this.elts[pos1] = this.elts[pos2];
        this.elts[pos2] = tmp;
    }

    public void insert(double key, int elem) {
        if (this.size == this.keys.length - 1 || elem > this.keys.length - 1) {
            this.doubleCapacity(elem);
        }
        ++this.size;
        int current = this.size;
        int parent = this.parent(current);
        while (current > 0 && this.keys[parent] > key) {
            this.keys[current] = this.keys[parent];
            this.elts[current] = this.elts[parent];
            this.posOf[this.elts[current]] = current;
            current = parent;
            parent = this.parent(current);
        }
        this.keys[current] = key;
        this.elts[current] = elem;
        this.posOf[elem] = current;
    }

    private void doubleCapacity(int elem) {
        int csize = Math.max(this.keys.length * 2 + 1, elem + 1);
        double[] dtmp = this.keys;
        this.keys = new double[csize];
        System.arraycopy(dtmp, 0, this.keys, 0, this.size + 1);
        int[] tmp = this.elts;
        this.elts = new int[csize];
        System.arraycopy(tmp, 0, this.elts, 0, this.size + 1);
        tmp = this.posOf;
        this.posOf = new int[csize];
        System.arraycopy(tmp, 0, this.posOf, 0, tmp.length);
    }

    public void update(double new_value, int elem) {
        int current = this.posOf[elem];
        double amount = new_value - this.keys[current];
        this.keys[current] = new_value;
        if (amount < 0.0) {
            this.pushup(current);
        } else if (amount > 0.0) {
            this.pushdown(current);
        }
    }

    public void print() {
        for (int i = 1; i <= this.size; ++i) {
            System.out.printf("(%.3f, %s) ", this.keys[i], this.elts[i]);
        }
        System.out.println();
    }

    public int removemin() {
        this.swap(1, this.size);
        --this.size;
        if (this.size != 0) {
            this.pushdown(1);
        }
        return this.elts[this.size + 1];
    }

    public int remove(int elem) {
        int idx = this.posOf[elem];
        this.swap(idx, this.size);
        --this.size;
        if (this.size != 0 && idx < this.size) {
            this.pushdown(idx);
        }
        return this.elts[this.size + 1];
    }

    private void pushdown(int position) {
        while (!this.isleaf(position)) {
            int smallestchild = this.leftchild(position);
            if (smallestchild < this.size && this.keys[smallestchild] > this.keys[smallestchild + 1]) {
                ++smallestchild;
            }
            if (smallestchild > this.size || this.keys[position] <= this.keys[smallestchild]) {
                return;
            }
            this.swap(position, smallestchild);
            position = smallestchild;
        }
    }

    private void pushup(int position) {
        while (this.keys[position] < this.keys[this.parent(position)]) {
            this.swap(position, this.parent(position));
            position = this.parent(position);
        }
    }

    public static void main(String[] args) {
        DoubleMinHeap mh = new DoubleMinHeap(10);
        for (int i = 1; i < 9; ++i) {
            mh.insert(i, i);
        }
        mh.print();
        mh.remove(2);
        mh.print();
        mh.remove(5);
        mh.print();
        mh.remove(8);
        mh.print();
        while (!mh.isEmpty()) {
            System.out.printf("%d\n", mh.removemin());
            mh.print();
        }
    }
}

