/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.queues;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.chocosolver.util.objects.queues.AQueue;

public class LinkedList<E>
implements AQueue<E>,
Serializable {
    transient int size;
    Entry<E> header = new Entry();
    Entry<E> free;

    public LinkedList() {
        this.header.previous = this.header;
        this.header.next = this.header.previous;
        this.free = new Entry();
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private Entry<E> entry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        Entry<E> e = this.header;
        if (index < this.size >> 1) {
            for (int i = 0; i <= index; ++i) {
                e = e.next;
            }
        } else {
            for (int i = this.size; i > index; --i) {
                e = e.previous;
            }
        }
        return e;
    }

    @Override
    public E get(int index) {
        return this.getEntry((int)index).element;
    }

    Entry<E> getEntry(int index) {
        return this.entry(index);
    }

    private Entry<E> addBefore(E e, Entry<E> entry) {
        Entry newEntry;
        if (this.free.next != null) {
            newEntry = this.free.next;
            this.free.next = newEntry.next;
        } else {
            newEntry = new Entry();
        }
        newEntry.element = e;
        newEntry.next = entry;
        newEntry.previous = entry.previous;
        newEntry.previous.next = newEntry;
        newEntry.next.previous = newEntry;
        ++this.size;
        return newEntry;
    }

    @Override
    public boolean addFirst(E e) {
        this.addBefore(e, this.header.next);
        return true;
    }

    @Override
    public boolean addLast(E e) {
        this.addBefore(e, this.header);
        return true;
    }

    E remove(Entry<E> e) {
        if (e == this.header) {
            throw new NoSuchElementException();
        }
        Object result = e.element;
        e.previous.next = e.next;
        e.next.previous = e.previous;
        e.previous = null;
        e.next = null;
        e.element = null;
        e.next = this.free.next;
        this.free.next = e;
        --this.size;
        return result;
    }

    @Override
    public E pollFirst() {
        return this.remove(this.header.next);
    }

    @Override
    public E pollLast() {
        return this.remove(this.header.previous);
    }

    @Override
    public E remove(int index) {
        return this.remove(this.getEntry(index));
    }

    @Override
    public boolean remove(E o) {
        Entry e = this.header.next;
        while (e != this.header) {
            if (o.equals(e.element)) {
                this.remove(e);
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public int indexOf(E o) {
        assert (o != null);
        int index = 0;
        Entry e = this.header.next;
        while (e != this.header) {
            if (o == e.element) {
                return index;
            }
            ++index;
            e = e.next;
        }
        return -1;
    }

    static class Entry<E> {
        public E element;
        public Entry<E> next;
        public Entry<E> previous;

        Entry() {
        }
    }
}

