/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.copy.EnvironmentCopying;
import org.chocosolver.memory.trailing.EnvironmentTrailing;
import org.chocosolver.solver.Solver;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.Set_Copy;
import org.chocosolver.util.objects.setDataStructures.Set_Full;
import org.chocosolver.util.objects.setDataStructures.Set_Std_BitSet;
import org.chocosolver.util.objects.setDataStructures.Set_Trail;
import org.chocosolver.util.objects.setDataStructures.linkedlist.Set_2LinkedList;
import org.chocosolver.util.objects.setDataStructures.linkedlist.Set_LinkedList;
import org.chocosolver.util.objects.setDataStructures.linkedlist.Set_Std_2LinkedList;
import org.chocosolver.util.objects.setDataStructures.linkedlist.Set_Std_LinkedList;
import org.chocosolver.util.objects.setDataStructures.linkedlist.Set_Std_LinkedList_NoRecycling;
import org.chocosolver.util.objects.setDataStructures.matrix.Set_Array;
import org.chocosolver.util.objects.setDataStructures.matrix.Set_BitSet;
import org.chocosolver.util.objects.setDataStructures.matrix.Set_Std_Array;
import org.chocosolver.util.objects.setDataStructures.swapList.Set_Std_Swap_Array;
import org.chocosolver.util.objects.setDataStructures.swapList.Set_Std_Swap_Hash;
import org.chocosolver.util.objects.setDataStructures.swapList.Set_Swap_Array;
import org.chocosolver.util.objects.setDataStructures.swapList.Set_Swap_Hash;

public class SetFactory {
    public static boolean HARD_CODED = true;
    public static boolean RECYCLE = true;

    public static ISet makeStoredSet(SetType type, int maximumSize, Solver solver) {
        IEnvironment environment = solver.getEnvironment();
        if (HARD_CODED) {
            switch (type) {
                case BIPARTITESET: {
                    return new Set_Std_Swap_Array(environment, maximumSize);
                }
                case SWAP_HASH: {
                    return new Set_Std_Swap_Hash(environment, maximumSize);
                }
                case LINKED_LIST: {
                    if (RECYCLE) {
                        return new Set_Std_LinkedList(environment);
                    }
                    return new Set_Std_LinkedList_NoRecycling(environment);
                }
                case DOUBLE_LINKED_LIST: {
                    return new Set_Std_2LinkedList(environment);
                }
                case BITSET: {
                    return new Set_Std_BitSet(environment, maximumSize);
                }
                case BOOL_ARRAY: {
                    return new Set_Std_Array(environment, maximumSize);
                }
            }
        }
        if (environment instanceof EnvironmentTrailing) {
            return new Set_Trail((EnvironmentTrailing)environment, SetFactory.makeSet(type, maximumSize));
        }
        if (environment instanceof EnvironmentCopying) {
            return new Set_Copy((EnvironmentCopying)environment, SetFactory.makeSet(type, maximumSize));
        }
        throw new UnsupportedOperationException("not implemented yet");
    }

    public static ISet makeSet(SetType type, int maximumSize) {
        switch (type) {
            case BIPARTITESET: {
                return SetFactory.makeSwap(maximumSize, false);
            }
            case SWAP_HASH: {
                return SetFactory.makeSwap(maximumSize, true);
            }
            case LINKED_LIST: {
                return SetFactory.makeLinkedList(false);
            }
            case DOUBLE_LINKED_LIST: {
                return SetFactory.makeLinkedList(true);
            }
            case BITSET: {
                return SetFactory.makeBitSet(maximumSize);
            }
            case BOOL_ARRAY: {
                return SetFactory.makeArray(maximumSize);
            }
        }
        throw new UnsupportedOperationException("unknown SetType");
    }

    public static ISet makeLinkedList(boolean doubleLink) {
        if (doubleLink) {
            return new Set_2LinkedList();
        }
        return new Set_LinkedList();
    }

    public static ISet makeBitSet(int n) {
        return new Set_BitSet(n);
    }

    public static ISet makeArray(int n) {
        return new Set_Array(n);
    }

    public static ISet makeFullSet(int n) {
        return new Set_Full(n);
    }

    public static ISet makeSwap(int n, boolean hash) {
        if (hash) {
            return new Set_Swap_Hash(n);
        }
        return new Set_Swap_Array(n);
    }
}

