/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.memory.structure.S64BitSet;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class Set_Std_BitSet
extends S64BitSet
implements ISet {
    protected int current = 0;
    protected IStateInt card;
    protected int n;

    public Set_Std_BitSet(IEnvironment environment, int nbits) {
        super(environment, nbits);
        this.card = environment.makeInt(0);
        this.n = nbits;
    }

    @Override
    public boolean add(int element) {
        if (!this.get(element)) {
            this.card.add(1);
            this.set(element, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(int element) {
        boolean isIn = this.get(element);
        if (isIn) {
            this.set(element, false);
            this.card.add(-1);
        }
        return isIn;
    }

    @Override
    public boolean contain(int element) {
        return this.get(element);
    }

    @Override
    public int getSize() {
        return this.card.get();
    }

    @Override
    public int getFirstElement() {
        this.current = this.nextSetBit(0);
        return this.current;
    }

    @Override
    public int getNextElement() {
        this.current = this.nextSetBit(this.current + 1);
        return this.current;
    }

    @Override
    public void clear() {
        super.clear();
        this.card.set(0);
    }

    @Override
    public SetType getSetType() {
        return SetType.BITSET;
    }

    @Override
    public int[] toArray() {
        int[] a = new int[this.getSize()];
        int idx = 0;
        int i = this.getFirstElement();
        while (i >= 0) {
            a[idx++] = i;
            i = this.getNextElement();
        }
        return a;
    }

    @Override
    public int getMaxSize() {
        return this.n;
    }
}

