/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures;

import org.chocosolver.memory.structure.Operation;
import org.chocosolver.memory.trailing.EnvironmentTrailing;
import org.chocosolver.util.PoolManager;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class Set_Trail
implements ISet {
    private final EnvironmentTrailing environment;
    private PoolManager<ListOP> operationPoolGC;
    private static final boolean ADD = true;
    private static final boolean REMOVE = false;
    private ISet set;

    public Set_Trail(EnvironmentTrailing environment, ISet set) {
        this.environment = environment;
        this.operationPoolGC = new PoolManager();
        this.set = set;
    }

    @Override
    public boolean add(int element) {
        if (this.set.add(element)) {
            ListOP op = this.operationPoolGC.getE();
            if (op == null) {
                new ListOP(element, false);
            } else {
                op.set(element, false);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(int element) {
        if (this.set.remove(element)) {
            ListOP op = this.operationPoolGC.getE();
            if (op == null) {
                new ListOP(element, true);
            } else {
                op.set(element, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contain(int element) {
        return this.set.contain(element);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public int getSize() {
        return this.set.getSize();
    }

    @Override
    public void clear() {
        int i = this.getFirstElement();
        while (i >= 0) {
            ListOP op = this.operationPoolGC.getE();
            if (op == null) {
                new ListOP(i, true);
            } else {
                op.set(i, true);
            }
            i = this.getNextElement();
        }
        this.set.clear();
    }

    @Override
    public int getFirstElement() {
        return this.set.getFirstElement();
    }

    @Override
    public int getNextElement() {
        return this.set.getNextElement();
    }

    public String toString() {
        return "set stored by trailing " + this.set.toString();
    }

    @Override
    public SetType getSetType() {
        return this.set.getSetType();
    }

    @Override
    public int[] toArray() {
        return this.set.toArray();
    }

    @Override
    public int getMaxSize() {
        return this.set.getMaxSize();
    }

    private class ListOP
    extends Operation {
        private int element;
        private boolean addOrRemove;

        public ListOP(int i, boolean add) {
            this.set(i, add);
        }

        @Override
        public void undo() {
            if (this.addOrRemove) {
                Set_Trail.this.set.add(this.element);
            } else {
                Set_Trail.this.set.remove(this.element);
            }
            Set_Trail.this.operationPoolGC.returnE(this);
        }

        public void set(int i, boolean add) {
            this.element = i;
            this.addOrRemove = add;
            Set_Trail.this.environment.save(this);
        }
    }
}

