/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.linkedlist;

import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class Set_2LinkedList
implements ISet {
    protected int size = 0;
    protected DoubleIntCell first = null;
    protected DoubleIntCell nextCell = null;
    protected DoubleIntCell poolGC = null;

    @Override
    public boolean isEmpty() {
        return this.first == null;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean contain(int element) {
        boolean res = false;
        DoubleIntCell current = this.first;
        while (!res && current != null) {
            if (current.element == element) {
                res = true;
            }
            current = current.next;
        }
        return res;
    }

    @Override
    public boolean add(int element) {
        if (this.poolGC == null) {
            this.first = new DoubleIntCell(element, this.first);
        } else {
            DoubleIntCell recycled = this.poolGC;
            this.poolGC = this.poolGC.next;
            recycled.init(element, this.first);
            this.first = recycled;
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(int element) {
        if (this.first != null && this.first.element == element) {
            DoubleIntCell old = this.poolGC;
            this.poolGC = this.first;
            this.first = this.first.next;
            if (this.first != null) {
                this.first.pred = null;
            }
            --this.size;
            this.poolGC.next = old;
            return true;
        }
        if (this.nextCell != null && this.nextCell.pred != null && this.nextCell.pred.element == element) {
            DoubleIntCell pred = this.nextCell.pred.pred;
            this.nextCell.pred.pred = null;
            this.nextCell.pred.next = null;
            DoubleIntCell old = this.poolGC;
            this.poolGC = this.nextCell.pred;
            if (pred != null) {
                pred.next = this.nextCell;
            }
            this.nextCell.pred = pred;
            --this.size;
            this.poolGC.next = old;
            return true;
        }
        DoubleIntCell current = this.first;
        boolean removed = false;
        while (!removed && current != null) {
            if (current.element == element) {
                if (current == this.nextCell) {
                    this.nextCell = this.nextCell.next;
                }
                DoubleIntCell old = this.poolGC;
                this.poolGC = current;
                DoubleIntCell nextCurrent = current.next;
                DoubleIntCell prevCurrent = current.pred;
                if (nextCurrent != null) {
                    nextCurrent.pred = prevCurrent;
                }
                if (prevCurrent != null) {
                    prevCurrent.next = nextCurrent;
                }
                removed = true;
                this.poolGC.next = old;
            }
            current = current.next;
        }
        if (removed) {
            --this.size;
        }
        return removed;
    }

    public String toString() {
        String res = "";
        DoubleIntCell current = this.first;
        while (current != null) {
            res = res + current;
            current = current.next;
        }
        return res;
    }

    @Override
    public void clear() {
        if (this.first != null) {
            this.first.next = this.poolGC;
            this.poolGC = this.first;
        }
        this.first = null;
        this.nextCell = null;
        this.size = 0;
    }

    @Override
    public int getFirstElement() {
        if (this.first == null) {
            return -1;
        }
        this.nextCell = this.first.next;
        return this.first.element;
    }

    @Override
    public int getNextElement() {
        if (this.nextCell == null) {
            return -1;
        }
        int el = this.nextCell.element;
        this.nextCell = this.nextCell.next;
        return el;
    }

    @Override
    public int[] toArray() {
        int[] a = new int[this.getSize()];
        int idx = 0;
        int i = this.getFirstElement();
        while (i >= 0) {
            a[idx++] = i;
            i = this.getNextElement();
        }
        return a;
    }

    @Override
    public int getMaxSize() {
        return -1;
    }

    @Override
    public SetType getSetType() {
        return SetType.DOUBLE_LINKED_LIST;
    }

    private class DoubleIntCell {
        DoubleIntCell pred;
        DoubleIntCell next;
        int element;

        public DoubleIntCell(int element, DoubleIntCell next) {
            this.init(element, next);
        }

        public void init(int element, DoubleIntCell next) {
            this.element = element;
            this.next = next;
            this.pred = null;
            if (next != null) {
                next.pred = this;
            }
        }

        public String toString() {
            if (this.next == null) {
                return "" + this.element;
            }
            return "" + this.element + " -> ";
        }
    }
}

