/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.linkedlist;

import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.linkedlist.IntCell;

public class Set_LinkedList
implements ISet {
    protected IntCell first = null;
    protected IntCell last = null;
    protected int size = 0;
    protected IntCell nextCell = null;
    protected IntCell poolGC = null;

    @Override
    public boolean isEmpty() {
        return this.first == null;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean contain(int element) {
        boolean res = false;
        IntCell current = this.first;
        while (!res && current != null) {
            if (current.element == element) {
                res = true;
            }
            current = current.next;
        }
        return res;
    }

    @Override
    public boolean add(int element) {
        if (this.poolGC == null) {
            this.first = new IntCell(element, this.first);
        } else {
            IntCell recycled = this.poolGC;
            this.poolGC = this.poolGC.next;
            recycled.init(element, this.first);
            this.first = recycled;
        }
        if (this.last == null) {
            assert (this.size == 0);
            this.last = this.first;
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(int element) {
        IntCell current = this.first;
        IntCell previous = null;
        boolean removed = false;
        while (!removed && current != null) {
            if (current.element == element) {
                if (current == this.nextCell) {
                    this.nextCell = this.nextCell.next;
                }
                IntCell old = this.poolGC;
                this.poolGC = current;
                if (previous == null) {
                    this.first = current.next;
                    if (this.first == null) {
                        this.last = null;
                    }
                } else {
                    previous.next = current.next;
                    if (current.next == null) {
                        this.last = previous;
                    }
                }
                removed = true;
                this.poolGC.next = old;
            }
            previous = current;
            current = current.next;
        }
        if (removed) {
            --this.size;
        }
        return removed;
    }

    public String toString() {
        String res = "";
        IntCell current = this.first;
        while (current != null) {
            res = res + current;
            current = current.next;
        }
        return res;
    }

    @Override
    public void clear() {
        if (this.first != null) {
            this.last.next = this.poolGC;
            this.poolGC = this.first;
        }
        this.first = null;
        this.last = null;
        this.nextCell = null;
        this.size = 0;
    }

    @Override
    public int getFirstElement() {
        if (this.first == null) {
            return -1;
        }
        this.nextCell = this.first.next;
        return this.first.element;
    }

    @Override
    public int getNextElement() {
        if (this.nextCell == null) {
            return -1;
        }
        int el = this.nextCell.element;
        this.nextCell = this.nextCell.next;
        return el;
    }

    @Override
    public SetType getSetType() {
        return SetType.LINKED_LIST;
    }

    @Override
    public int[] toArray() {
        int[] a = new int[this.getSize()];
        int idx = 0;
        int i = this.getFirstElement();
        while (i >= 0) {
            a[idx++] = i;
            i = this.getNextElement();
        }
        return a;
    }

    @Override
    public int getMaxSize() {
        return -1;
    }
}

