/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.linkedlist;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.structure.Operation;
import org.chocosolver.util.objects.setDataStructures.linkedlist.Set_2LinkedList;

public class Set_Std_2LinkedList
extends Set_2LinkedList {
    final IEnvironment environment;
    public static final boolean ADD = true;
    public static final boolean REMOVE = false;
    ListOP[] operationPoolGC;
    int poolCurrentSize;

    public Set_Std_2LinkedList(IEnvironment environment) {
        this.environment = environment;
        this.operationPoolGC = new ListOP[16];
    }

    @Override
    public boolean add(int element) {
        this._add(element);
        if (this.poolCurrentSize <= 0) {
            new ListOP(element, false);
        } else {
            ListOP op = this.operationPoolGC[--this.poolCurrentSize];
            op.set(element, false);
        }
        return true;
    }

    protected void _add(int element) {
        super.add(element);
    }

    @Override
    public boolean remove(int element) {
        boolean done = this._remove(element);
        if (done) {
            if (this.poolCurrentSize <= 0) {
                new ListOP(element, true);
            } else {
                ListOP op = this.operationPoolGC[--this.poolCurrentSize];
                op.set(element, true);
            }
        }
        return done;
    }

    protected boolean _remove(int element) {
        return super.remove(element);
    }

    @Override
    public void clear() {
        int i = this.getFirstElement();
        while (i >= 0) {
            if (this.poolCurrentSize <= 0) {
                new ListOP(i, true);
            } else {
                ListOP op = this.operationPoolGC[--this.poolCurrentSize];
                op.set(i, true);
            }
            i = this.getNextElement();
        }
        super.clear();
    }

    private class ListOP
    extends Operation {
        int element;
        boolean addOrRemove;

        public ListOP(int i, boolean add) {
            this.set(i, add);
        }

        @Override
        public void undo() {
            if (this.addOrRemove) {
                Set_Std_2LinkedList.this._add(this.element);
            } else {
                Set_Std_2LinkedList.this._remove(this.element);
            }
            if (Set_Std_2LinkedList.this.poolCurrentSize == Set_Std_2LinkedList.this.operationPoolGC.length) {
                ListOP[] tmp = new ListOP[Set_Std_2LinkedList.this.poolCurrentSize * 4 / 3 + 10];
                System.arraycopy(Set_Std_2LinkedList.this.operationPoolGC, 0, tmp, 0, Set_Std_2LinkedList.this.poolCurrentSize);
                Set_Std_2LinkedList.this.operationPoolGC = tmp;
            }
            Set_Std_2LinkedList.this.operationPoolGC[Set_Std_2LinkedList.this.poolCurrentSize++] = this;
        }

        public void set(int i, boolean add) {
            this.element = i;
            this.addOrRemove = add;
            Set_Std_2LinkedList.this.environment.save(this);
        }
    }
}

