/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.matrix;

import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class Set_Array
implements ISet {
    protected boolean[] elements;
    private int n;
    private int size;
    protected int current;

    public Set_Array(int n) {
        this.n = n;
        this.elements = new boolean[n];
        this.size = 0;
    }

    @Override
    public boolean add(int element) {
        if (!this.elements[element]) {
            ++this.size;
            this.elements[element] = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(int element) {
        if (this.elements[element]) {
            --this.size;
            this.elements[element] = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean contain(int element) {
        return this.elements[element];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.n && this.size > 0; ++i) {
            if (this.elements[i]) {
                --this.size;
            }
            this.elements[i] = false;
        }
    }

    @Override
    public int getFirstElement() {
        this.current = 0;
        return this.getNextElement();
    }

    @Override
    public int getNextElement() {
        int i;
        for (i = this.current; i < this.n && !this.elements[i]; ++i) {
        }
        if (i < this.n) {
            this.current = i + 1;
            return i;
        }
        return -1;
    }

    @Override
    public SetType getSetType() {
        return SetType.BOOL_ARRAY;
    }

    @Override
    public int[] toArray() {
        int[] a = new int[this.getSize()];
        int idx = 0;
        int i = this.getFirstElement();
        while (i >= 0) {
            a[idx++] = i;
            i = this.getNextElement();
        }
        return a;
    }

    @Override
    public int getMaxSize() {
        return this.n;
    }
}

