/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.matrix;

import java.util.BitSet;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class Set_BitSet
extends BitSet
implements ISet {
    private int current = 0;
    private int card = 0;
    private int n;

    public Set_BitSet(int nbits) {
        super(nbits);
        this.n = nbits;
    }

    @Override
    public boolean add(int element) {
        if (!this.get(element)) {
            ++this.card;
            this.set(element, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(int element) {
        boolean isIn = this.get(element);
        if (isIn) {
            this.set(element, false);
            --this.card;
        }
        return isIn;
    }

    @Override
    public boolean contain(int element) {
        return this.get(element);
    }

    @Override
    public boolean isEmpty() {
        return this.cardinality() == 0;
    }

    @Override
    public int getSize() {
        return this.card;
    }

    @Override
    public int getFirstElement() {
        this.current = this.nextSetBit(0);
        return this.current;
    }

    @Override
    public int getNextElement() {
        this.current = this.nextSetBit(this.current + 1);
        return this.current;
    }

    @Override
    public void clear() {
        this.card = 0;
        super.clear();
    }

    @Override
    public SetType getSetType() {
        return SetType.BITSET;
    }

    @Override
    public int[] toArray() {
        int[] a = new int[this.getSize()];
        int idx = 0;
        int i = this.getFirstElement();
        while (i >= 0) {
            a[idx++] = i;
            i = this.getNextElement();
        }
        return a;
    }

    @Override
    public int getMaxSize() {
        return this.n;
    }
}

