/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.matrix;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateBool;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class Set_Std_Array
implements ISet {
    protected IStateBool[] elements;
    private IStateInt size;
    private int n;
    protected int current;

    public Set_Std_Array(IEnvironment environment, int n) {
        this.n = n;
        this.elements = new IStateBool[n];
        this.size = environment.makeInt(0);
        for (int i = 0; i < n; ++i) {
            this.elements[i] = environment.makeBool(false);
        }
    }

    @Override
    public boolean add(int element) {
        if (!this.elements[element].get()) {
            this.size.add(1);
            this.elements[element].set(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(int element) {
        if (this.elements[element].get()) {
            this.size.add(-1);
            this.elements[element].set(false);
            return true;
        }
        return false;
    }

    @Override
    public boolean contain(int element) {
        return this.elements[element].get();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public void clear() {
        int s = this.size.get();
        this.size.set(0);
        for (int i = 0; i < this.n && s > 0; ++i) {
            if (this.elements[i].get()) {
                --s;
            }
            this.elements[i].set(false);
        }
    }

    @Override
    public int getFirstElement() {
        this.current = 0;
        return this.getNextElement();
    }

    @Override
    public int getNextElement() {
        int i;
        for (i = this.current; i < this.n && !this.elements[i].get(); ++i) {
        }
        if (i < this.n) {
            this.current = i + 1;
            return i;
        }
        return -1;
    }

    @Override
    public SetType getSetType() {
        return SetType.BOOL_ARRAY;
    }

    @Override
    public int[] toArray() {
        int[] a = new int[this.getSize()];
        int idx = 0;
        int i = this.getFirstElement();
        while (i >= 0) {
            a[idx++] = i;
            i = this.getNextElement();
        }
        return a;
    }

    @Override
    public int getMaxSize() {
        return this.n;
    }
}

