/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.swapList;

import org.chocosolver.util.objects.setDataStructures.ISet;

public abstract class Set_Swap
implements ISet {
    protected int arrayLength;
    protected int currentIdx;
    protected int size = 0;
    protected final int sizeMax;
    protected int[] array;

    public Set_Swap(int n) {
        this.sizeMax = n;
        this.arrayLength = 16;
        this.array = new int[this.arrayLength];
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    protected void setSize(int s) {
        this.size = s;
    }

    protected void addSize(int delta) {
        this.size += delta;
    }

    public String toString() {
        int size = this.getSize();
        if (size == 0) {
            return "empty";
        }
        String res = "";
        for (int i = 0; i < size - 1; ++i) {
            res = res + this.array[i] + " -> ";
        }
        res = res + this.array[size - 1];
        return res;
    }

    @Override
    public void clear() {
        this.setSize(0);
    }

    @Override
    public int getFirstElement() {
        if (this.getSize() == 0) {
            return -1;
        }
        this.currentIdx = 0;
        return this.array[this.currentIdx];
    }

    @Override
    public int getNextElement() {
        ++this.currentIdx;
        if (this.currentIdx >= this.getSize()) {
            return -1;
        }
        return this.array[this.currentIdx];
    }

    @Override
    public int[] toArray() {
        int[] a = new int[this.getSize()];
        int idx = 0;
        int i = this.getFirstElement();
        while (i >= 0) {
            a[idx++] = i;
            i = this.getNextElement();
        }
        return a;
    }

    @Override
    public int getMaxSize() {
        return this.sizeMax;
    }
}

