/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.swapList;

import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.swapList.Set_Swap;

public class Set_Swap_Array
extends Set_Swap {
    protected int[] map;

    public Set_Swap_Array(int n) {
        super(n);
        this.map = new int[n];
        for (int i = 0; i < n; ++i) {
            this.map[i] = -1;
        }
    }

    @Override
    public boolean contain(int element) {
        return this.map[element] >= 0 && this.map[element] < this.getSize() && this.array[this.map[element]] == element;
    }

    @Override
    public boolean add(int element) {
        if (this.contain(element)) {
            return false;
        }
        int size = this.getSize();
        if (this.getSize() == this.arrayLength) {
            int[] tmp = this.array;
            int ns = Math.min(this.sizeMax, tmp.length + 1 + tmp.length * 2 / 3);
            this.array = new int[ns];
            this.arrayLength = ns;
            System.arraycopy(tmp, 0, this.array, 0, size);
        }
        this.array[size] = element;
        this.map[element] = size;
        this.addSize(1);
        return true;
    }

    @Override
    public boolean remove(int element) {
        int size = this.getSize();
        if (this.map[element] >= 0) {
            if (size == 1) {
                this.setSize(0);
                return true;
            }
            int idx = this.map[element];
            if (idx < size) {
                int replacer = this.array[size - 1];
                this.map[replacer] = idx;
                this.array[idx] = replacer;
                this.map[element] = size - 1;
                this.array[size - 1] = element;
                this.addSize(-1);
                if (idx == this.currentIdx) {
                    --this.currentIdx;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public SetType getSetType() {
        return SetType.BIPARTITESET;
    }
}

