/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.swapList;

import gnu.trove.map.hash.TIntIntHashMap;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.swapList.Set_Swap;

public class Set_Swap_Hash
extends Set_Swap {
    protected TIntIntHashMap map = new TIntIntHashMap();

    public Set_Swap_Hash(int n) {
        super(n);
    }

    @Override
    public boolean contain(int element) {
        return this.map.containsKey(element) && this.array[this.map.get(element)] == element && this.map.get(element) < this.getSize();
    }

    @Override
    public boolean add(int element) {
        if (this.contain(element)) {
            return false;
        }
        int size = this.getSize();
        if (this.getSize() == this.arrayLength) {
            int[] tmp = this.array;
            int ns = Math.min(this.sizeMax, tmp.length + 1 + tmp.length * 2 / 3);
            this.array = new int[ns];
            this.arrayLength = ns;
            System.arraycopy(tmp, 0, this.array, 0, size);
        }
        this.array[size] = element;
        this.map.remove(element);
        this.map.put(element, size);
        this.addSize(1);
        return true;
    }

    @Override
    public boolean remove(int element) {
        int idx;
        int size = this.getSize();
        if (this.map.containsKey(element) && (idx = this.map.get(element)) < size) {
            if (size == 1) {
                this.setSize(0);
                return true;
            }
            int replacer = this.array[size - 1];
            this.map.adjustValue(replacer, idx - size + 1);
            this.array[idx] = replacer;
            this.map.adjustValue(element, size - 1 - idx);
            this.array[size - 1] = element;
            this.addSize(-1);
            if (idx == this.currentIdx) {
                --this.currentIdx;
            }
            return true;
        }
        return false;
    }

    @Override
    public SetType getSetType() {
        return SetType.SWAP_HASH;
    }
}

