/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.tools;

import gnu.trove.list.array.TIntArrayList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;

public enum ArrayUtils {


    public static int[] zeroToN(int n) {
        int[] r = new int[n];
        for (int i = 0; i < n; ++i) {
            r[i] = i;
        }
        return r;
    }

    public static int[] oneToN(int n) {
        int[] r = new int[n];
        for (int i = 1; i <= n; ++i) {
            r[i - 1] = i;
        }
        return r;
    }

    public static int[] linspace(int begin, int end) {
        if (end > begin) {
            int[] r = new int[end - begin];
            for (int i = begin; i < end; ++i) {
                r[i - begin] = i;
            }
            return r;
        }
        return null;
    }

    public static <T> T[] getColumn(T[][] array, int column) {
        if (array != null && array.length > 0 && column >= 0 && array[0].length > column) {
            Object[] res = (Object[])Array.newInstance(array[0][column].getClass(), array.length);
            for (int i = 0; i < array.length; ++i) {
                res[i] = array[i][column];
            }
            return res;
        }
        return null;
    }

    public static <T> T[] getColumn(T[][] array, int column, Class clazz) {
        if (array != null && array.length > 0 && column >= 0 && array[0].length > column) {
            Object[] res = (Object[])Array.newInstance(clazz, array.length);
            for (int i = 0; i < array.length; ++i) {
                res[i] = array[i][column];
            }
            return res;
        }
        return null;
    }

    @SafeVarargs
    public static <T> int length(T[] ... arrays) {
        int length = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            length += array.length;
        }
        return length;
    }

    public static <T> boolean contains(T[] array, T obj) {
        for (T elem : array) {
            if (!elem.equals(obj)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> T get(int index, T[] ... arrays) {
        int shift = index;
        for (T[] tab : arrays) {
            if (shift < tab.length) {
                return tab[shift];
            }
            shift -= tab.length;
        }
        return null;
    }

    @SafeVarargs
    public static <T> T get(int index, List<T> ... arrays) {
        int shift = index;
        for (List<T> tab : arrays) {
            if (shift < tab.size()) {
                return tab.get(shift);
            }
            shift -= tab.size();
        }
        return null;
    }

    public static <T> T[] append(T[] ... toAppend) {
        int total = ArrayUtils.length(toAppend);
        Object[] ret = (Object[])Array.newInstance(toAppend.getClass().getComponentType().getComponentType(), total);
        int pos = 0;
        for (T[] tab : toAppend) {
            if (tab == null) continue;
            System.arraycopy(tab, 0, ret, pos, tab.length);
            pos += tab.length;
        }
        return ret;
    }

    public static int[] append(int[] ... toAppend) {
        int total = 0;
        for (int[] tab : toAppend) {
            if (tab == null) continue;
            total += tab.length;
        }
        int[] ret = new int[total];
        int pos = 0;
        for (int[] tab : toAppend) {
            if (tab == null) continue;
            System.arraycopy(tab, 0, ret, pos, tab.length);
            pos += tab.length;
        }
        return ret;
    }

    public static void inverseSign(int[] tab) {
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = -tab[i];
        }
    }

    public static void reverse(int[] tab) {
        int n = tab.length;
        for (int i = 0; i < n / 2; ++i) {
            int tmp = tab[i];
            tab[i] = tab[n - i - 1];
            tab[n - i - 1] = tmp;
        }
    }

    public static <T> void reverse(T[] tab) {
        int n = tab.length - 1;
        for (int i = 0; i < n / 2; ++i) {
            T tmp = tab[i];
            tab[i] = tab[n - i];
            tab[n - i] = tmp;
        }
    }

    public static <T> void permutation(int[] permutation, T[] tab) {
        Object[] tmp = (Object[])Array.newInstance(tab[0].getClass(), tab.length);
        System.arraycopy(tab, 0, tmp, 0, tab.length);
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = tmp[permutation[i]];
        }
    }

    public static <T> List<T> toList(T[] array) {
        return Arrays.asList(array);
    }

    public static <T> T[] toArray(Class c, List<T> list) {
        return list.toArray((Object[])Array.newInstance(c, list.size()));
    }

    @SafeVarargs
    public static <T> T[] toArray(T ... elt) {
        return elt;
    }

    public static <T> T[] toArray(ArrayList<T> list) {
        return ArrayUtils.toArray(list.get(0).getClass(), list);
    }

    public static <T> T[][] transpose(T[][] matrix) {
        int i;
        Object[][] ret = (Object[][])Array.newInstance(matrix.getClass().getComponentType(), matrix[0].length);
        for (i = 0; i < ret.length; ++i) {
            ret[i] = (Object[])Array.newInstance(matrix[0].getClass().getComponentType(), matrix.length);
        }
        for (i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                ret[j][i] = matrix[i][j];
            }
        }
        return ret;
    }

    public static int[][] transpose(int[][] matrix) {
        int i;
        int[][] ret = (int[][])Array.newInstance(matrix.getClass().getComponentType(), matrix[0].length);
        for (i = 0; i < ret.length; ++i) {
            ret[i] = (int[])Array.newInstance(matrix[0].getClass().getComponentType(), matrix.length);
        }
        for (i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                ret[j][i] = matrix[i][j];
            }
        }
        return ret;
    }

    public static <T> T[] flatten(T[][] matrix) {
        int sz = 0;
        for (T[] t : matrix) {
            sz += t.length;
        }
        Object[] ret = (Object[])Array.newInstance(matrix[0].getClass().getComponentType(), sz);
        int k = 0;
        T[][] TArray = matrix;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T[] ta;
            for (T t : ta = TArray[i]) {
                ret[k++] = t;
            }
        }
        return ret;
    }

    public static <T> T[] flatten(T[][][] matrix) {
        ArrayList<T> elt = new ArrayList<T>();
        T[][][] TArray = matrix;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T[][] t;
            for (T[] tt : t = TArray[i]) {
                elt.addAll(Arrays.asList(tt));
            }
        }
        Object[] ret = (Object[])Array.newInstance(matrix[0][0].getClass().getComponentType(), elt.size());
        return elt.toArray(ret);
    }

    public static <T> T[] flattenSubMatrix(int iMin, int iLength, int jMin, int jLength, T[][] matrix) {
        Object[] ret = (Object[])Array.newInstance(matrix[0].getClass().getComponentType(), iLength * jLength);
        int i = 0;
        int k = 0;
        while (i < iLength) {
            System.arraycopy(matrix[iMin + i], jMin, ret, k, jLength);
            ++i;
            k += jLength;
        }
        return ret;
    }

    public static int[] flatten(int[][] matrix) {
        int sz = 0;
        for (int[] t : matrix) {
            sz += t.length;
        }
        int[] ret = new int[sz];
        int k = 0;
        int[][] nArray = matrix;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] ta;
            for (int t : ta = nArray[i]) {
                ret[k++] = t;
            }
        }
        return ret;
    }

    public static int[] createNonRedundantSortedValues(TIntArrayList values) {
        values.sort();
        for (int offset = 1; offset < values.size(); ++offset) {
            while (values.get(offset - 1) == values.get(offset)) {
                values.remove(offset);
                if (offset != values.size()) continue;
            }
        }
        return values.toArray();
    }

    public static <T extends Comparable<T>> T[] sort(Set<T> set) {
        LinkedList<Object> tmpl = new LinkedList<Object>(set);
        if (tmpl.isEmpty()) {
            return null;
        }
        Object[] tmpa = (Comparable[])Array.newInstance(((Comparable)tmpl.getFirst()).getClass(), tmpl.size());
        tmpl.toArray(tmpa);
        Arrays.sort(tmpa);
        return tmpa;
    }

    public static int[][][][] swallowCopy(int[][][][] arr) {
        int s0 = arr.length;
        int[][][][] copy = new int[s0][][][];
        for (int i = s0 - 1; i >= 0; --i) {
            int s1 = arr[i].length;
            copy[i] = new int[s1][][];
            for (int j = s1 - 1; j >= 0; --j) {
                int s2 = arr[i][j].length;
                copy[i][j] = new int[s2][];
                for (int k = s2 - 1; k >= 0; --k) {
                    int s3 = arr[i][j][k].length;
                    copy[i][j][k] = new int[s3];
                    System.arraycopy(arr[i][j][k], 0, copy[i][j][k], 0, s3);
                }
            }
        }
        return copy;
    }

    public static int[][][] swallowCopy(int[][][] arr) {
        int s0 = arr.length;
        int[][][] copy = new int[s0][][];
        for (int i = s0 - 1; i >= 0; --i) {
            int s1 = arr[i].length;
            copy[i] = new int[s1][];
            for (int j = s1 - 1; j >= 0; --j) {
                int s2 = arr[i][j].length;
                copy[i][j] = new int[s2];
                System.arraycopy(arr[i][j], 0, copy[i][j], 0, s2);
            }
        }
        return copy;
    }

    public static int[] zeroToNShuffle(int nb) {
        return ArrayUtils.zeroToNShuffle(nb, System.nanoTime());
    }

    public static int[] zeroToNShuffle(int nb, long seed) {
        int i;
        Random r = new Random(seed);
        int[] ret = new int[nb];
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (i = 0; i < nb; ++i) {
            tmp.add(i);
        }
        for (i = 0; i < nb; ++i) {
            int idx = r.nextInt(tmp.size());
            ret[i] = (Integer)tmp.get(idx);
            System.err.println(ret[i]);
            System.err.println(tmp.remove(idx));
        }
        return ret;
    }

    public static int[] randomPermutations(int[] tab, Random r) {
        int l = tab.length;
        for (int i = 0; i < l; ++i) {
            int j = r.nextInt(l);
            int tmp = tab[i];
            tab[i] = tab[j];
            tab[j] = tmp;
        }
        return tab;
    }

    public static int[] randomPermutations(int[] tab, long seed) {
        return ArrayUtils.randomPermutations(tab, new Random(seed));
    }

    public static <E> E[] randomPermutations(E[] tab, Random r) {
        int l = tab.length;
        for (int i = 0; i < l; ++i) {
            int j = r.nextInt(l);
            E tmp = tab[i];
            tab[i] = tab[j];
            tab[j] = tmp;
        }
        return tab;
    }

    public static <E> E[] randomPermutations(E[] tab, long seed) {
        return ArrayUtils.randomPermutations(tab, new Random(seed));
    }
}

