/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.tools;

import java.awt.Point;

public final class MathUtils {
    public static final double ROUNDED_LOG_PRECISION = 10000.0;

    private MathUtils() {
    }

    public static long factoriel(int n) {
        return n < 2 ? 1L : (long)n * MathUtils.factoriel(n - 1);
    }

    public static int combinaison(int n, int p) {
        if (n == p) {
            return 1;
        }
        if (p == 0) {
            return 1;
        }
        if (p == 1) {
            return n;
        }
        return MathUtils.combinaison(n - 1, p) + MathUtils.combinaison(n - 1, p - 1);
    }

    public static boolean isPowerOfTwo(int x) {
        return (x & x - 1) == 0;
    }

    public static int pow(int value, int exp) {
        return value == 2 ? 1 << exp : (int)Math.pow(value, exp);
    }

    public static double log(double value, double exponent) {
        return Math.log(value) / Math.log(exponent);
    }

    public static double roundedLog(double value, double exponent) {
        return (double)Math.round(MathUtils.log(value, exponent) * 10000.0) / 10000.0;
    }

    public static int sum(int[] values, int begin, int end) {
        int s = 0;
        for (int i = begin; i < end; ++i) {
            s += values[i];
        }
        return s;
    }

    public static int sumFrom(int[] values, int begin) {
        return MathUtils.sum(values, begin, values.length);
    }

    public static int sumTo(int[] values, int end) {
        return MathUtils.sum(values, 0, end);
    }

    public static int sum(int[] values) {
        return MathUtils.sum(values, 0, values.length);
    }

    public static int sum(int[][] values) {
        int s = 0;
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[i].length; ++j) {
                s += values[i][j];
            }
        }
        return s;
    }

    public static int max(int[] values) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] <= max) continue;
            max = values[i];
        }
        return max;
    }

    public static int max(int[][] values) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[i].length; ++j) {
                if (values[i][j] <= max) continue;
                max = values[i][j];
            }
        }
        return max;
    }

    public static int min(int[] values) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] >= min) continue;
            min = values[i];
        }
        return min;
    }

    public static int min(int[][] values) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[i].length; ++j) {
                if (values[i][j] >= min) continue;
                min = values[i][j];
            }
        }
        return min;
    }

    public static Point bounds(int[] values) {
        if (values == null || values.length == 0) {
            return new Point(Integer.MAX_VALUE, Integer.MIN_VALUE);
        }
        Point b = new Point(values[0], values[0]);
        for (int i = 1; i < values.length; ++i) {
            if (values[i] < b.x) {
                b.x = values[i];
                continue;
            }
            if (values[i] <= b.y) continue;
            b.y = values[i];
        }
        return b;
    }

    public static int divFloor(int a, int b) {
        if (b < 0) {
            return MathUtils.divFloor(-a, -b);
        }
        if (b > 0) {
            if (a >= 0) {
                return a / b;
            }
            return (a - b + 1) / b;
        }
        assert (b == 0);
        return Integer.MAX_VALUE;
    }

    public static int divCeil(int a, int b) {
        if (b < 0) {
            return MathUtils.divCeil(-a, -b);
        }
        if (b > 0) {
            if (a >= 0) {
                return (a + b - 1) / b;
            }
            return a / b;
        }
        assert (b == 0);
        return Integer.MIN_VALUE;
    }
}

